% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_exposed_population_acled.R
\name{calc_exposed_population_acled}
\alias{calc_exposed_population_acled}
\title{Calculate population exposed to violent conflict from ACLED}
\usage{
calc_exposed_population_acled(
  distance = 5000,
  filter_category = c("event_type", "sub_event_type", "disorder_type"),
  filter_types = NULL,
  years = c(1997:2024),
  precision_location = 1,
  precision_time = 1
)
}
\arguments{
\item{distance}{A numeric vector indicating the buffer radius in meters.
If length is 1, the same buffer size around included conflict events is
drawn. Otherwise, it must be equal to the length of included categories
selected with \code{filter_types}.}

\item{filter_category}{A character indicating the categories to be used
to calculate the exposed population by. Defaults to \code{event_type} meaning
one estimation per event type will be returned.}

\item{filter_types}{A character vector of event types of the respective
category specified in \code{filter_category} to retain. Defaults to NULL,
meaning that no filter is applied and all types are retained.}

\item{years}{A numeric vector indicating for which years to calculate
the exposed population. Restricted to available years for ACLED.
For years not intersecting with available WorldPop layers, the first layer
is used for earlier years and the last layer to more recent years.}

\item{precision_location}{A numeric indicating precision value for the
geolocation up to which events are included. Defaults to 1.}

\item{precision_time}{A numeric indicating the precision value of the
temporal coding up to which events are included. Defaults to 1.}
}
\value{
A function that returns an indicator tibble with conflict exposure
as variable and precentage of the population as its value.
}
\description{
The indicator calculates the population exposed to conflict events within a
specified buffer distance around events in ACLED. Per default,
the first available WorldPop layer is used to estimate exposed populations
for years before the respective year, while the most recent layer is
used for years after.
}
\details{
The indicator is inspired by the Conflict Exposure tool from ACLED (see
citation below), but differs in the regard that we simply flatten our
buffered event layer instead of applying voronoi tessellation.

The required resources for this indicator are:
\itemize{
\item \link{acled}
\item \link{worldpop}
}

Events in ACLED are classified according to the schema described extensively
in their codebook.
You may filter for certain types of events. The categories for which a
filter can be applied are either "event_type", "event_sub_type", or
"disorder_type". These are translated into the following categories:
\itemize{
\item event_type:
\itemize{
\item battles
\item protests
\item riots
\item explosions/remote_violence
\item violence_against_civilians
\item strategic_developments
}
\item event_sub_type:
\itemize{
\item government_regains_territory
\item non-state_actor_overtakes_territory
\item armed_clash
\item excessive_force_against_protesters
\item protest_with_intervention
\item peaceful_protest
\item violent_demonstration
\item mob_violence
\item chemical_weapon
\item air/drone_strike
\item suicide_bomb
\item shelling/artillery/missile_attack
\item remote_explosive/landmine/ied
\item grenade
\item sexual_violence
\item attack
\item abduction/forced_disappearance
\item agreement
\item arrests
\item change_to_group/activity
\item disrupted_weapons_use
\item headquarters_or_base_established
\item looting/property_destruction
\item non-violent_transfer_of_territory
\item other
}
\item disorder_type:
\itemize{
\item political_violence
\item political_violence;_demonstrations
\item demonstrations
\item political_violence
\item strategic_developments
}
}

You may supply buffer distances for each of the event categories. Custom
buffers will then be drawn per category. Supply a single value if you
do not wish do differentiate between categories. Otherwise, supply a
vector of distances equal to the length of included categories.

You may apply quality filters based on the precision of the geolocation
of events and the temporal precision. By default, these are set to only
include events with the highest precision scores.

For geo-precision there are levels 1 to 3 with decreasing accuracy:
\itemize{
\item value 1: the source reporting indicates a particular town, and coordinates
are available for that town
\item value 2: the source material indicates that activity took place in a
small part of a region, and mentions a general area or if an activity
occurs near a town or a city, the event is coded to a town with
geo-referenced coordinates to represent that area
\item value 3: a larger region is mentioned, the closest natural location noted
in reporting (like “border area,” “forest,” or “sea,” among others) – or a
provincial capital is used if no other information at all is available
}

For temporal precision there are levels 1 to 3 with decreasing precision:
\itemize{
\item value 1: the source material includes an actual date of an event
\item value 2: the source material indicates that an event happened sometime
during the week or within a similar period of time
\item value 3: the source material only indicates that an event took place
sometime during a month (i.e. in the past two or three weeks, or in
January), without reference to the particular date, the month mid-point
is chosen
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
if (FALSE) {
  library(sf)
  library(mapme.biodiversity)

  outdir <- file.path(tempdir(), "mapme-data")
  dir.create(outdir, showWarnings = FALSE)

  mapme_options(
    outdir = outdir,
    verbose = FALSE,
    chunk_size = 1e8
  )

  aoi <- system.file("extdata", "burundi.gpkg",
    package = "mapme.biodiversity"
  ) \%>\%
    read_sf() \%>\%
    get_resources(
      get_acled(year = 2000),
      get_worldpop(years = 2000)
    ) \%>\%
    calc_indicators(
      conflict_exposure_acled(
        distance = 5000,
        years = 2000,
        precision_location = 1,
        precision_time = 1
      )
    ) \%>\%
    portfolio_long()

  aoi
}
}
}
\references{
Raleigh, C; C Dowd; A Tatem; A Linke; N Tejedor-Garavito; M
Bondarenko and K Kishi. 2023. Assessing and Mapping Global and Local
Conflict Exposure. Working Paper.
}
\keyword{indicator}
