% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_key_biodiversity_areas.R
\docType{data}
\name{key_biodiversity_areas_indicator}
\alias{key_biodiversity_areas_indicator}
\alias{calc_key_biodiversity_area}
\title{Calculate Key Biodiversity Areas}
\format{
A function returning an indicator tibble with \code{key_biodiversity_area}
as variable and the total overlap area (in ha) as value.
}
\usage{
calc_key_biodiversity_area()
}
\description{
This function calculates the total area of key biodiversity areas for a given
input polygon.
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{key_biodiversity_areas_resource}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- read_sf(
  system.file("extdata", "shell_beach_protected_area_41057_B.gpkg",
              package = "mapme.biodiversity"
))
kbas <- system.file("res", "key_biodiversity_areas", "kbas.gpkg",
                    package = "mapme.biodiversity")
aoi <- get_resources(aoi, get_key_biodiversity_areas(kbas))
aoi <- calc_indicators(aoi, calc_key_biodiversity_area())
aoi <- portfolio_long(aoi)

aoi
}
}
\keyword{indicator}
