% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_acled.R
\name{acled}
\alias{acled}
\alias{get_acled}
\title{Armed Conflict Location & Event Data (ACLED)}
\source{
Armed Conflict Location & Event Data Project (ACLED).
}
\usage{
get_acled(
  years = 2000,
  key = Sys.getenv("ACLED_ACCESS_KEY"),
  email = Sys.getenv("ACLED_ACCESS_EMAIL"),
  accept_terms = FALSE
)
}
\arguments{
\item{years}{A numeric vector specifying the years for which to make
ACLED data available (between 1997 and today). Defaults to 2000.}

\item{key}{ACLED API key obtained by registering with ACLED (see Details).}

\item{email}{Email addressed used to register with ACLED (see Details).}

\item{accept_terms}{A logical indicating if you agree to abid by ACLED's terms
of use. Defaults to FALSE, thus must be manually set to TRUE.}
}
\value{
A function that returns an \code{sf} footprint object.
}
\description{
From ACLED's homepage: \emph{The Armed Conflict Location & Event Data Project
(ACLED) is a disaggregated data collection, analysis, and crisis mapping
project. ACLED collects information on the dates, actors, locations,
fatalities, and types of all reported political violence and protest events
around the world. The ACLED team conducts analysis to describe, explore, and
test conflict scenarios, and makes both data and analysis open for free use
by the public.}
}
\details{
In order to access data from the ACLED API, you first must register an
an account. Note, that the ACLED API used here provides a \emph{living database}
with single events being altered or removed altogether over time.
}
\references{
Raleigh, C., Kishi, R. & Linke, A. Political instability patterns
are obscured by conflict dataset scope conditions, sources, and coding
choices. Humanit Soc Sci Commun 10, 74 (2023).
\doi{https://doi.org/10.1057/s41599-023-01559-4}
}
\keyword{resource}
