% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_pie_charts.R
\name{build_pie_chart}
\alias{build_pie_chart}
\title{Build Pie Chart}
\usage{
build_pie_chart(
  df,
  location,
  cols = NULL,
  border = 0.3,
  opacity = 1,
  border_col = "black"
)
}
\arguments{
\item{df}{data.frame (see examples).}

\item{location}{string containing the site to subset.}

\item{cols}{vector of colours the same length as the number of clusters.}

\item{border}{numeric value of zero or greater.}

\item{opacity}{numeric value of zero to one.}

\item{border_col}{string denoting colour of pie border.}
}
\value{
A ggplot object.
}
\description{
Internal function used to build a pie chart using ggplot
}
\examples{
df <- data.frame(
  site = c("London","London","London","Paris","Paris","Paris",
           "Berlin","Berlin","Berlin","Rome","Rome","Rome",
           "Madrid","Madrid","Madrid"),
  cluster = c("Cluster1","Cluster2","Cluster3","Cluster1","Cluster2","Cluster3",
              "Cluster1","Cluster2","Cluster3","Cluster1","Cluster2","Cluster3",
              "Cluster1","Cluster2","Cluster3"),
  value = c(0.95, 0.05, 0, 0.50, 0.45, 0.05, 0.10, 0.45, 0.45, 0,
            0.01, 0.99, 0, 0.75, 0.25)
)

build_pie_chart(df, location = "London")
}
\keyword{internal}
