% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.R
\name{group_mappoly}
\alias{group_mappoly}
\title{Assign markers to linkage groups}
\usage{
group_mappoly(
  input.mat,
  expected.groups = NULL,
  inter = TRUE,
  comp.mat = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{input.mat}{an object of class \code{mappoly.rf.matrix}}

\item{expected.groups}{when available, inform the number of expected 
linkage groups (i.e. chromosomes) for the species}

\item{inter}{if \code{TRUE} (default), plots a dendrogram highlighting the
expected groups before continue}

\item{comp.mat}{if \code{TRUE}, shows a comparison between the reference
based and the linkage based grouping, if the sequence information is
available (default = FALSE)}

\item{verbose}{logical. If \code{TRUE} (default), current progress is shown;
if \code{FALSE}, no output is produced}
}
\value{
Returns an object of class \code{mappoly.group}, which is a list
    containing the following components:
    \item{data.name}{the referred dataset name}
    \item{hc.snp}{a list containing information related to 
    the UPGMA grouping method}
    \item{expected.groups}{the number of expected linkage groups}
    \item{groups.snp}{the groups to which each of the markers belong}
    \item{seq.vs.grouped.snp}{comparison between the genomic group information
    (when available) and the groups provided by \code{group_mappoly}}
    \item{chisq.pval.thres}{the threshold used on the segregation test when reading the dataset}
    \item{chisq.pval}{the p-values associated with the segregation test for all markers in the sequence}
}
\description{
Identifies linkage groups of markers using the results of two-point
(pairwise) analysis.
}
\examples{
    ## Getting first 20 markers from two linkage groups
    all.mrk <- make_seq_mappoly(hexafake, c(1:20,601:620))
    red.mrk <- elim_redundant(all.mrk)
    unique.mrks <- make_seq_mappoly(red.mrk)
    counts <- cache_counts_twopt(unique.mrks, cached = TRUE)
    all.pairs <- est_pairwise_rf(input.seq = unique.mrks,
                                 count.cache = counts,
                                 ncpus = 1,
                                 verbose=TRUE)

    ## Full recombination fraction matrix
    mat.full<-rf_list_to_matrix(input.twopt=all.pairs)
    plot(mat.full, index = FALSE)

    lgs <- group_mappoly(input.mat = mat.full,
                         expected.groups = 2,
                         inter = TRUE,
                         comp.mat = TRUE, #this data has physical information
                         verbose = TRUE)
    lgs
    plot(lgs)
   
}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \url{https://doi.org/10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
