% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/reestimate_map_with_prior_genotypic_probability.R
\name{est_full_hmm_with_prior_prob}
\alias{est_full_hmm_with_prior_prob}
\title{Re-estimate genetic map using dosage prior probability distribution}
\usage{
est_full_hmm_with_prior_prob(
  input.map,
  dat.prob = NULL,
  phase.config = "best",
  tol = 0.001,
  verbose = FALSE
)
}
\arguments{
\item{input.map}{an object of class \code{mappoly.map}}

\item{dat.prob}{an object of class \code{mappoly.data} containing the
probability distribution of the genotypes}

\item{phase.config}{which phase configuration should be used. "best" (default) 
will choose the maximum likelihood configuration}

\item{tol}{the desired accuracy (default = 10e-04)}

\item{verbose}{if \code{TRUE}, current progress is shown; if
\code{FALSE} (default), no output is produced}
}
\value{
A list of class \code{mappoly.map} with two elements: 

i) info:  a list containing information about the map, regardless of the linkage phase configuration:
\item{m}{the ploidy level}
\item{n.mrk}{number of markers}
\item{seq.num}{a vector containing the (ordered) indices of markers in the map, 
               according to the input file}
\item{mrk.names}{the names of markers in the map}
\item{seq.dose.p}{a vector containing the dosage in parent 1 for all markers in the map}
\item{seq.dose.q}{a vector containing the dosage in parent 2 for all markers in the map}
\item{sequence}{a vector indicating the sequence (usually chromosome) each marker belongs 
                as informed in the input file. If not available, 
                \code{sequence = NULL}}
\item{sequence.pos}{physical position (usually in megabase) of the markers into the sequence}
\item{seq.ref}{reference base used for each marker (i.e. A, T, C, G). If not available, 
                \code{seq.ref = NULL}}                 
\item{seq.alt}{alternative base used for each marker (i.e. A, T, C, G). If not available, 
                \code{seq.ref = NULL}}
\item{chisq.pval}{a vector containing p-values of the chi-squared test of Mendelian 
                  segregation for all markers in the map}                 
\item{data.name}{name of the dataset of class \code{mappoly.data}}
\item{ph.thres}{the LOD threshold used to define the linkage phase configurations to test}

ii) a list of maps with possible linkage phase configuration. Each map in the list is also a 
   list containing
\item{seq.num}{a vector containing the (ordered) indices of markers in the map, 
               according to the input file}
\item{seq.rf}{a vector of size (\code{n.mrk - 1}) containing a sequence of recombination 
              fraction between the adjacent markers in the map}
\item{seq.ph}{linkage phase configuration for all markers in both parents}
\item{loglike}{the hmm-based multipoint likelihood}
}
\description{
This function considers dosage prior distribution when re-estimating
a genetic map using Hidden Markov models
}
\examples{
    submap <- get_submap(solcap.dose.map[[1]], mrk.pos = 1:20, verbose = FALSE)
    prob.submap <- est_full_hmm_with_prior_prob(submap,
                                                dat.prob = tetra.solcap.geno.dist,
                                                tol=10e-4, 
                                                verbose = TRUE)
    prob.submap
    plot_map_list(list(dose = submap, prob = prob.submap), 
                  title = "estimation procedure")

}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
