% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_map_hmm.R
\name{est_rf_hmm_single}
\alias{est_rf_hmm_single}
\title{Multipoint analysis using Hidden Markov Models (single phase)}
\usage{
est_rf_hmm_single(
  input.seq,
  input.ph.single,
  rf.temp = NULL,
  tol,
  verbose = FALSE,
  ret.map.no.rf.estimation = FALSE,
  high.prec = TRUE,
  max.rf.to.break.EM = 0.5
)
}
\arguments{
\item{void}{internal function to be documented}
}
\description{
Multipoint analysis using Hidden Markov Models (single phase)
}
\examples{
  \donttest{
    seq.all.mrk <- make_seq_mappoly(hexafake, 1:20)
    id <- get_genomic_order(seq.all.mrk)
    s.go <- make_seq_mappoly(id)
    ## Using the 5 contiguous markers
    seq5 <- make_seq_mappoly(hexafake, s.go$seq.mrk.names[6:10])
    twopt <- est_pairwise_rf(seq5)
    l5 <- ls_linkage_phases(input.seq = seq5, thres = 2, twopt = twopt)
    plot(l5)
    
    ## Evaluating 2 linkage phase configurations using HMM
    maps1 <- vector("list", length(l5$config.to.test))
    for(i in 1:length(maps1))
      maps1[[i]] <- est_rf_hmm_single(seq5, l5$config.to.test[[i]], 
                                      tol = 10e-3,
                                      high.prec = FALSE)
   (best <- which.max(sapply(maps1, function(x) x$loglike)))
   dist1 <- round(cumsum(c(0, imf_h(maps1[[best]]$seq.rf))),2)
   
   ## Same thing using automatic search
   maps2 <- est_rf_hmm(input.seq = seq5, twopt = twopt, thres = 2, 
                     verbose = TRUE, tol = 10e-3, high.prec = FALSE)
   plot(maps2)
   dist1
 }
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
\keyword{internal}
