% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_map_by_steps.R
\name{add_md_markers}
\alias{add_md_markers}
\title{Add markers to a pre-existing sequence using HMM analysis and evaluating difference in LOD}
\usage{
add_md_markers(
  input.map,
  mrk.to.include,
  input.seq,
  input.matrix,
  input.genoprob,
  input.data,
  input.mds = NULL,
  thresh = 500,
  extend.tail = 50,
  method = c("hmm", "wMDS_to_1D_pc"),
  verbose = TRUE
)
}
\arguments{
\item{input.map}{An object of class \code{mappoly.map}}

\item{mrk.to.include}{vector for marker names to be included}

\item{input.seq}{an object of class \code{mappoly.sequence} containing all markers (the ones in the mappoly.map and also the ones to be included)}

\item{input.matrix}{object of class \code{mappoly.rf.matrix}}

\item{input.genoprob}{an object of class \code{mappoly.genoprob} obtained with calc_genoprob of the input.map object}

\item{input.data}{an object of class \code{mappoly.data}}

\item{input.mds}{An object of class \code{mappoly.map}}

\item{thresh}{the LOD threshold used to determine if the marker will be included or not after hmm analysis  (default = 30)}

\item{extend.tail}{the length of the chain's tail that should be used to calculate the likelihood of 
the map. If NULL (default), the function uses all markers positioned. Even if info.tail = TRUE, 
it uses at least extend.tail as the tail length}

\item{method}{indicates whether to use 'hmm' (Hidden Markov Models), 'ols' (Ordinary Least Squares) or 'wMDS_to_1D_pc' 
(weighted MDS followed by fitting a one dimensional principal curve) to re-estimate the recombination fractions after adding markers}

\item{verbose}{If TRUE (default), current progress is shown; if FALSE, no output is produced}
}
\description{
Add markers to a pre-existing sequence using HMM analysis and evaluating difference in LOD
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu} with documentation and minor modifications by Cristiane Taniguti \email{chtaniguti@tamu.edu}
}
\keyword{internal}
