% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_map_sc.R
\name{mf_symb_choro}
\alias{mf_symb_choro}
\title{Plot symbols using choropleth coloration}
\usage{
mf_symb_choro(
  x,
  var,
  pal = "Mint",
  breaks = "quantile",
  nbreaks,
  border,
  pch,
  cex = 1,
  lwd = 0.7,
  pch_na = 4,
  cex_na = 1,
  col_na = "white",
  val_order,
  leg_pos = mf_get_leg_pos(x, 2),
  leg_title = var,
  leg_title_cex = c(0.8, 0.8),
  leg_val_cex = c(0.6, 0.6),
  leg_val_rnd = 2,
  leg_no_data = c("No data", "No data"),
  leg_frame = c(FALSE, FALSE),
  add
)
}
\arguments{
\item{x}{object of class \code{sf}}

\item{var}{name(s) of the variable(s) to plot}

\item{pal}{a set of colors or a palette name (from \link{hcl.colors})}

\item{breaks}{either a numeric vector with the actual breaks, or a classification method name (see \link{mf_get_breaks})}

\item{nbreaks}{number of classes}

\item{border}{border color}

\item{pch}{pch for symbols}

\item{cex}{cex for symbols}

\item{lwd}{border width}

\item{pch_na}{pch for NA values}

\item{cex_na}{cex for NA values}

\item{col_na}{color for missing values}

\item{val_order}{val order}

\item{leg_pos}{position of the legend, one of 'topleft', 'top','topright', 'right', 'bottomright', 'bottom', 'bottomleft', 'left' or a vector of two coordinates in map units (c(x, y)). If leg_pos is 'n' then the legend is not plotted.}

\item{leg_title}{legend title}

\item{leg_title_cex}{size of the legend title}

\item{leg_val_cex}{size of the values in the legend}

\item{leg_val_rnd}{number of decimal places of the values in the legend}

\item{leg_no_data}{label for missing values}

\item{leg_frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{add}{whether to add the layer to an existing plot (TRUE) or not (FALSE)}
}
\value{
No return value, a map is displayed.
}
\description{
Plot symbols with colors based on a quantitative
data classification.
}
\examples{
mtq <- mf_get_mtq()
mf_map(mtq)
mf_symb_choro(mtq, c("STATUS", "MED"))

mf_map(mtq)
mtq$STATUS[30] <- NA
mtq$MED[5] <- NA
mf_symb_choro(mtq, c("STATUS", "MED"),
  pal = "Reds 3", breaks = "quantile", nbreaks = 4,
  pch = 21:23, cex = c(3, 2, 1),
  pch_na = 25, cex_na = 1.5, col_na = "blue",
  val_order = c(
    "Prefecture",
    "Sub-prefecture",
    "Simple municipality"
  )
)
}
\keyword{internal}
