% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_map_c.R
\name{mf_choro}
\alias{mf_choro}
\title{Plot a choropleth map}
\usage{
mf_choro(
  x,
  var,
  pal = "Mint",
  alpha = 1,
  breaks = "quantile",
  nbreaks,
  border,
  pch = 21,
  cex = 1,
  lwd = 0.7,
  col_na = "white",
  cex_na = 1,
  pch_na = 4,
  leg_pos = mf_get_leg_pos(x),
  leg_title = var,
  leg_title_cex = 0.8,
  leg_val_cex = 0.6,
  leg_val_rnd = 2,
  leg_no_data = "No data",
  leg_frame = FALSE,
  add = FALSE
)
}
\arguments{
\item{x}{object of class \code{sf}}

\item{var}{name(s) of the variable(s) to plot}

\item{pal}{a set of colors or a palette name (from \link{hcl.colors})}

\item{alpha}{if \code{pal} is a \link{hcl.colors} palette name, the alpha-transparency level in the range [0,1]}

\item{breaks}{either a numeric vector with the actual breaks, or a classification method name (see \link{mf_get_breaks})}

\item{nbreaks}{number of classes}

\item{border}{border color}

\item{pch}{pch type of pch if x is a POINT layer}

\item{cex}{cex cex of the symbols if x is a POINT layer}

\item{lwd}{border width}

\item{col_na}{color for missing values}

\item{cex_na}{cex for NA values if x is a POINT layer}

\item{pch_na}{pch for NA values if x is a POINT layer}

\item{leg_pos}{position of the legend, one of 'topleft', 'top','topright', 'right', 'bottomright', 'bottom', 'bottomleft', 'left' or a vector of two coordinates in map units (c(x, y)). If leg_pos is 'n' then the legend is not plotted.}

\item{leg_title}{legend title}

\item{leg_title_cex}{size of the legend title}

\item{leg_val_cex}{size of the values in the legend}

\item{leg_val_rnd}{number of decimal places of the values in the legend}

\item{leg_no_data}{label for missing values}

\item{leg_frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{add}{whether to add the layer to an existing plot (TRUE) or not (FALSE)}
}
\value{
No return value, a map is displayed.
}
\description{
Plot choropleth map.
}
\examples{
mtq <- mf_get_mtq()
mf_choro(mtq, "MED")

mtq[6, "MED"] <- NA
mf_choro(
  x = mtq, var = "MED", col_na = "grey", pal = "Cividis",
  breaks = "quantile", nbreaks = 4, border = "white",
  lwd = .5, leg_pos = "topleft",
  leg_title = "Median Income", leg_title_cex = 1.1,
  leg_val_cex = 1, leg_val_rnd = -2, leg_no_data = "No data",
  leg_frame = TRUE
)
}
\keyword{internal}
