% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datagrid.R
\name{datagrid}
\alias{datagrid}
\title{Generate a data grid of "typical," "counterfactual," or user-specified values for use in the \code{newdata} argument of the \code{marginaleffects} or \code{predictions} functions.}
\usage{
datagrid(
  ...,
  model = NULL,
  newdata = NULL,
  grid.type = "typical",
  FUN.character = Mode,
  FUN.factor = Mode,
  FUN.logical = Mode,
  FUN.numeric = function(x) mean(x, na.rm = TRUE),
  FUN.other = function(x) mean(x, na.rm = TRUE)
)
}
\arguments{
\item{...}{named arguments with vectors of values for user-specified
variables. The output will include all combinations of these variables (see
Examples below.)}

\item{model}{Model object}

\item{newdata}{data.frame (one and only one of the \code{model} and \code{newdata} arguments}

\item{grid.type}{character
\itemize{
\item "typical": variables whose values are not explicitly specified by the user in \code{...} are set to their mean or mode, or to the output of the functions supplied to \code{FUN.type} arguments.
\item "counterfactual": the entire dataset is duplicated for each combination of the variable values specified in \code{...}.
}}

\item{FUN.character}{the function to be applied to character variables.}

\item{FUN.factor}{the function to be applied to factor variables.}

\item{FUN.logical}{the function to be applied to factor variables.}

\item{FUN.numeric}{the function to be applied to numeric variables.}

\item{FUN.other}{the function to be applied to other variable types.}
}
\value{
A \code{data.frame} in which each row corresponds to one combination of the named
predictors supplied by the user via the \code{...} dots. Variables which are not
explicitly defined are held at their mean or mode.
}
\description{
Generate a data grid of "typical," "counterfactual," or user-specified values for use in the \code{newdata} argument of the \code{marginaleffects} or \code{predictions} functions.
}
\details{
If \code{datagrid} is used in a \code{marginaleffects} or \code{predictions} call as the
\code{newdata} argument, users do not need to specify the \code{model} or \code{newdata}
argument. The data is extracted automatically from the model.

If users supply a model, the data used to fit that model is retrieved using
the \code{insight::get_data} function.
}
\examples{
# The output only has 2 rows, and all the variables except `hp` are at their
# mean or mode.
datagrid(newdata = mtcars, hp = c(100, 110))

# We get the same result by feeding a model instead of a data.frame
mod <- lm(mpg ~ hp, mtcars)
datagrid(model = mod, hp = c(100, 110))

# Use in `marginaleffects` to compute "Typical Marginal Effects". When used
# in `marginaleffects()` or `predictions()` we do not need to specify the
#`model` or `newdata` arguments.
marginaleffects(mod, newdata = datagrid(hp = c(100, 110)))

# The full dataset is duplicated with each observation given counterfactual
# values of 100 and 110 for the `hp` variable. The original `mtcars` includes
# 32 rows, so the resulting dataset includes 64 rows.
dg <- datagrid(newdata = mtcars, hp = c(100, 110), grid.type = "counterfactual")
nrow(dg)

# We get the same result by feeding a model instead of a data.frame
mod <- lm(mpg ~ hp, mtcars)
dg <- datagrid(model = mod, hp = c(100, 110), grid.type = "counterfactual")
nrow(dg)
}
