% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mat.polyn.R
\name{pol.mul}
\alias{pol.mul}
\title{pol.mul}
\usage{
pol.mul(eta, theta, L)
}
\arguments{
\item{eta}{first matrix polynomial}

\item{theta}{second matrix olynomial}

\item{L}{order of output polynomial (length = L+1)}
}
\value{
matrix polynomial product af eta and theta
}
\description{
Calculation of product of two matrix
polynomials (arrays).

If one or both leading unity matrices (of eta and theta) are
missing, they are (it is)
generated (and taken into account).
}
\examples{
set.seed(4711)
p1 <- check.one(matrix(rnorm(16), nrow=4))
p2 <- check.one(array(rnorm(32),dim=c(4, 4, 2)))
p12 <- pol.mul(p1, p2, L=(2+3))
short.form(p12)

}

