% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defining.programs.R
\name{short.form}
\alias{short.form}
\title{short.form}
\usage{
short.form(poly = NULL, name = "Lag=", leading = TRUE, tail = FALSE,
  digits = 6)
}
\arguments{
\item{poly}{matrix polynomium (0-1 array as construced by define.model,
for example, or array of reals as estimated by marima).}

\item{name}{character string used as header in output (default='lag').}

\item{leading}{TRUE/FALSE. If leading=FALSE the leading (unity matrix)
is to be left out/suppressed.}

\item{tail}{TRUE/FALSE. If TRUE and the ar/ma-model only consists
of coefficient matrice(s) where all coefficients (except the
leading unity matrix) are all zero a first order coefficient matrix
(being zero) is retained (in order to avoid a model containing only
the leading unity matrix).

If tail=TRUE and the coefficients in the first coefficient matrix
(after the leading unity matrix) are all zero, the leading unity
matrix is always retained.}

\item{digits}{the number of digits retained by short.form (default=6).}
}
\description{
Function to condensate (and/or) print out matrix
polynomium leaving out empty lag matrices and, if specified,
the leading (unity) matrix.
}
\examples{
Model<-define.model(kvar=4, ar=c(1, 2, 4), ma=c(1), reg.var=4)
short.form(Model$ar.pattern)
short.form(Model$ma.pattern)
short.form(Model$ar.pattern, leading=FALSE)
short.form(Model$ar.pattern, leading=FALSE)
#
M<-define.model(kvar=4, ma=c(1))
short.form(M$ar.pattern)
short.form(M$ar.pattern, tail=TRUE)
short.form(M$ar.pattern, leading=FALSE, tail=TRUE)

}

