% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directory.R
\name{add_file_timestamp}
\alias{add_file_timestamp}
\title{Add file timestamp}
\usage{
add_file_timestamp(x, ts = Sys.time(), format = "\%Y-\%m-\%d \%H\%M\%S")
}
\arguments{
\item{x}{A vector of files}

\item{ts}{A single timestamp or vector of timestamps (default: \code{Sys.time()})}

\item{format}{A format to be applied to the times; set to \code{NULL} to skip formatting}
}
\value{
The full name paths with the appended time stamp
}
\description{
Adds a timestamp to a file
}
\examples{
file1 <- tempfile(fileext = ".txt")
file2 <- tempfile()

add_file_timestamp(file1)
add_file_timestamp(file2)

file.remove(file1, file2)
}
