% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R,
%   R/diseq_stochastic_adjustment.R, R/market_fit.R
\name{shortage_analysis}
\alias{shortage_analysis}
\alias{shortages}
\alias{normalized_shortages}
\alias{relative_shortages}
\alias{shortage_probabilities}
\alias{shortage_indicators}
\alias{shortage_standard_deviation}
\alias{shortages,missing,market_model,ANY-method}
\alias{normalized_shortages,missing,market_model,ANY-method}
\alias{relative_shortages,missing,market_model,ANY-method}
\alias{shortage_probabilities,missing,market_model,ANY-method}
\alias{shortage_indicators,missing,market_model,ANY-method}
\alias{shortage_standard_deviation,missing,market_model,ANY-method}
\alias{shortage_standard_deviation,missing,diseq_stochastic_adjustment,ANY-method}
\alias{shortages,market_fit,missing,missing-method}
\alias{normalized_shortages,market_fit,missing,missing-method}
\alias{relative_shortages,market_fit,missing,missing-method}
\alias{shortage_probabilities,market_fit,missing,missing-method}
\alias{shortage_indicators,market_fit,missing,missing-method}
\alias{shortage_standard_deviation,market_fit,missing,missing-method}
\title{Analysis of shortages}
\usage{
shortages(fit, model, parameters)

normalized_shortages(fit, model, parameters)

relative_shortages(fit, model, parameters)

shortage_probabilities(fit, model, parameters)

shortage_indicators(fit, model, parameters)

shortage_standard_deviation(fit, model, parameters)

\S4method{shortages}{missing,market_model,ANY}(model, parameters)

\S4method{normalized_shortages}{missing,market_model,ANY}(model, parameters)

\S4method{relative_shortages}{missing,market_model,ANY}(model, parameters)

\S4method{shortage_probabilities}{missing,market_model,ANY}(model, parameters)

\S4method{shortage_indicators}{missing,market_model,ANY}(model, parameters)

\S4method{shortage_standard_deviation}{missing,market_model,ANY}(model, parameters)

\S4method{shortage_standard_deviation}{missing,diseq_stochastic_adjustment,ANY}(model, parameters)

\S4method{shortages}{market_fit,missing,missing}(fit)

\S4method{normalized_shortages}{market_fit,missing,missing}(fit)

\S4method{relative_shortages}{market_fit,missing,missing}(fit)

\S4method{shortage_probabilities}{market_fit,missing,missing}(fit)

\S4method{shortage_indicators}{market_fit,missing,missing}(fit)

\S4method{shortage_standard_deviation}{market_fit,missing,missing}(fit)
}
\arguments{
\item{fit}{A fitted model object.}

\item{model}{A market model object.}

\item{parameters}{A vector of parameters at which the shortages are evaluated.}
}
\value{
A vector with the (estimated) shortages.
}
\description{
The following methods offer functionality for analyzing estimated
shortages of the market models. The methods can be called either
using directly a fitted model object, or by separately providing a model
object and a parameter vector.
}
\details{
\subsection{shortages}{
Returns the predicted shortages at a given point.
}

\subsection{normalized_shortages}{
Returns the shortages normalized by the variance of the difference of the shocks
at a given point.
}

\subsection{relative_shortages}{
Returns the shortages normalized by the supplied quantity at a given point.
}

\subsection{shortage_probabilities}{
Returns the shortage probabilities, i.e. the probabilities of an
observation coming from an excess demand state, at the given point.
}

\subsection{shortage_indicators}{
Returns a vector of indicators (Boolean values) for each observation. An
element of the vector is TRUE for observations at which the estimated
shortages are non-negative, i.e. the market at in an excess demand state.
The remaining elements are FALSE. The evaluation of the shortages is
performed using the passed parameter vector.
}

\subsection{shortage_standard_deviation}{
Returns the standard deviation of excess demand.
}
}
\section{Functions}{
\itemize{
\item \code{shortages}: Shortages.

\item \code{normalized_shortages}: Normalized shortages.

\item \code{relative_shortages}: Relative shortages.

\item \code{shortage_probabilities}: Shortage probabilities.

\item \code{shortage_indicators}: Shortage indicators.

\item \code{shortage_standard_deviation}: Shortage standard deviation.
}}

\examples{
\donttest{
# estimate a model using the houses dataset
fit <- diseq_deterministic_adjustment(
  HS | RM | ID | TREND ~
    RM + TREND + W + CSHS + L1RM + L2RM + MONTH |
      RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH,
  fair_houses(),
  correlated_shocks = FALSE,
  estimation_options = list(control = list(maxit = 1e+5))
)

# get estimated normalized shortages
head(normalized_shortages(fit))

# get estimated relative shortages
head(relative_shortages(fit))

# get the estimated shortage probabilities
head(shortage_probabilities(fit))

# get the estimated shortage indicators
head(shortage_indicators(fit))

# get the estimated shortages
head(shortages(fit))

# get the estimated shortage standard deviation
shortage_standard_deviation(fit)
}
}
