/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.solver.variables.integer.AbstractIntDomain;
import choco.cp.solver.variables.integer.BipartiteIntDomain;
import choco.cp.solver.variables.integer.BitSetIntDomain;
import choco.cp.solver.variables.integer.BooleanDomain;
import choco.cp.solver.variables.integer.IntVarEvent;
import choco.cp.solver.variables.integer.IntervalBTreeDomain;
import choco.cp.solver.variables.integer.IntervalIntDomain;
import choco.cp.solver.variables.integer.LinkedIntDomain;
import choco.cp.solver.variables.integer.OneValueIntDomain;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.memory.structure.Couple;
import choco.kernel.memory.structure.PartiallyStoredIntCstrList;
import choco.kernel.memory.structure.PartiallyStoredIntVector;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.propagation.event.VarEvent;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class IntDomainVarImpl<C extends AbstractSConstraint>
extends AbstractVar
implements IntDomainVar {
    protected AbstractIntDomain domain;

    protected <C extends AbstractIntSConstraint> IntDomainVarImpl(Solver solver, String name) {
        super(solver, name, new PartiallyStoredIntCstrList(solver.getEnvironment(), IntVarEvent.EVENTS));
    }

    public IntDomainVarImpl(Solver solver, String name, int domainType, int a, int b) {
        this(solver, name);
        switch (domainType) {
            case 0: {
                this.domain = new BitSetIntDomain(this, a, b, solver.getEnvironment(), this.propagationEngine);
                break;
            }
            case 1: {
                this.domain = new IntervalIntDomain(this, a, b, solver.getEnvironment(), this.propagationEngine);
                break;
            }
            case 2: {
                this.domain = new LinkedIntDomain(this, a, b, solver.getEnvironment(), this.propagationEngine);
                break;
            }
            case 3: {
                this.domain = new IntervalBTreeDomain(this, a, b, solver.getEnvironment(), this.propagationEngine);
                break;
            }
            case 4: {
                this.domain = new BipartiteIntDomain(this, a, b, solver.getEnvironment(), this.propagationEngine);
                break;
            }
            case 5: {
                this.domain = new BooleanDomain(this, solver.getEnvironment(), this.propagationEngine);
                break;
            }
            case 6: {
                this.domain = new OneValueIntDomain(this, a, this.propagationEngine);
                break;
            }
            default: {
                this.domain = new IntervalIntDomain(this, a, b, solver.getEnvironment(), this.propagationEngine);
            }
        }
        this.event = new IntVarEvent(this);
    }

    public IntDomainVarImpl(Solver solver, String name, int domainType, int[] distinctSortedValues) {
        this(solver, name);
        switch (domainType) {
            case 0: {
                this.domain = new BitSetIntDomain(this, distinctSortedValues, solver.getEnvironment(), this.propagationEngine);
                break;
            }
            case 3: {
                this.domain = new IntervalBTreeDomain(this, distinctSortedValues, solver.getEnvironment(), this.propagationEngine);
                break;
            }
            case 2: {
                this.domain = new LinkedIntDomain(this, distinctSortedValues, solver.getEnvironment(), this.propagationEngine);
                break;
            }
            case 4: {
                this.domain = new BipartiteIntDomain(this, distinctSortedValues, solver.getEnvironment(), this.propagationEngine);
                break;
            }
            case 6: {
                this.domain = new OneValueIntDomain(this, distinctSortedValues[0], this.propagationEngine);
                break;
            }
            default: {
                this.domain = new BitSetIntDomain(this, distinctSortedValues, solver.getEnvironment(), this.propagationEngine);
            }
        }
        this.event = new IntVarEvent(this);
    }

    public final DisposableIterator<Couple<C>> getActiveConstraints(int evtType, C cstrCause) {
        return ((PartiallyStoredIntCstrList)this.constraints).getActiveConstraint(evtType, cstrCause);
    }

    public final PartiallyStoredIntVector[] getEventsVector() {
        return ((PartiallyStoredIntCstrList)this.constraints).getEventsVector();
    }

    @Override
    public boolean isInstantiatedTo(int x) {
        return this.isInstantiated() && this.getVal() == x;
    }

    @Override
    public boolean isInstantiated() {
        return this.domain.getSize() == 1;
    }

    @Override
    public boolean canBeInstantiatedTo(int x) {
        return this.getInf() <= x && x <= this.getSup() && (this.domain == null || this.domain.contains(x));
    }

    @Override
    public boolean fastCanBeInstantiatedTo(int x) {
        return this.domain.contains(x);
    }

    @Override
    public void setInf(int x) throws ContradictionException {
        this.updateInf(x, null, true);
    }

    @Override
    public void setMin(int x) throws ContradictionException {
        this.updateInf(x, null, true);
    }

    @Override
    public void setSup(int x) throws ContradictionException {
        this.updateSup(x, null, true);
    }

    @Override
    public void setMax(int x) throws ContradictionException {
        this.updateSup(x, null, true);
    }

    @Override
    public void setVal(int x) throws ContradictionException {
        this.instantiate(x, null, true);
    }

    @Override
    public void remVal(int x) throws ContradictionException {
        this.removeVal(x, null, true);
    }

    @Override
    public void wipeOut() throws ContradictionException {
        this.propagationEngine.raiseContradiction(this);
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return this.domain.isEnumerated();
    }

    @Override
    public boolean hasBooleanDomain() {
        return this.domain.isBoolean();
    }

    @Override
    public IntDomain getDomain() {
        return this.domain;
    }

    @Override
    public int getDomainSize() {
        return this.domain.getSize();
    }

    @Override
    public boolean canBeEqualTo(IntDomainVar x) {
        if (x.getInf() <= this.getSup()) {
            if (this.getInf() <= x.getSup()) {
                if (!this.hasEnumeratedDomain() || !x.hasEnumeratedDomain()) {
                    return true;
                }
                DisposableIntIterator it = this.getDomain().getIterator();
                while (it.hasNext()) {
                    int v = it.next();
                    if (!x.canBeInstantiatedTo(v)) continue;
                    it.dispose();
                    return true;
                }
                it.dispose();
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean canBeInstantiatedIn(int[] sortedValList, int nVals) {
        if (this.getInf() <= sortedValList[nVals - 1]) {
            if (this.getSup() >= sortedValList[0]) {
                if (this.domain == null) {
                    return true;
                }
                for (int i = 0; i < nVals; ++i) {
                    if (!this.canBeInstantiatedTo(sortedValList[i])) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public int getRandomDomainValue() {
        if (this.domain == null) {
            return this.getInf();
        }
        return this.domain.getRandomValue();
    }

    @Override
    public int getNextDomainValue(int currentv) {
        if (currentv < this.getInf()) {
            return this.getInf();
        }
        if (this.domain == null) {
            return currentv + 1;
        }
        return this.domain.getNextValue(currentv);
    }

    @Override
    public int fastNextDomainValue(int i) {
        return this.domain.fastNextValue(i);
    }

    @Override
    public int getPrevDomainValue(int currentv) {
        if (currentv > this.getSup()) {
            return this.getSup();
        }
        if (this.domain == null) {
            return currentv - 1;
        }
        return this.domain.getPrevValue(currentv);
    }

    @Override
    public int fastPrevDomainValue(int i) {
        return this.domain.fastPrevValue(i);
    }

    @Deprecated
    private SConstraint getCause(int idx) {
        if (idx < -1) {
            return this.getConstraint(VarEvent.domOverWDegInitialIdx(idx));
        }
        if (idx > -1) {
            return this.getConstraint(idx);
        }
        return null;
    }

    @Override
    public boolean updateInf(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        return this.domain.updateInf(x, cause, forceAwake);
    }

    @Override
    @Deprecated
    public boolean updateInf(int x, int idx) throws ContradictionException {
        return this.domain.updateInf(x, this.getCause(idx), idx < 0);
    }

    @Override
    public boolean updateSup(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        return this.domain.updateSup(x, cause, forceAwake);
    }

    @Override
    @Deprecated
    public boolean updateSup(int x, int idx) throws ContradictionException {
        return this.domain.updateSup(x, this.getCause(idx), idx < 0);
    }

    @Override
    public boolean removeVal(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        return this.domain.removeVal(x, cause, forceAwake);
    }

    @Override
    @Deprecated
    public boolean removeVal(int x, int idx) throws ContradictionException {
        return this.domain.removeVal(x, this.getCause(idx), idx < 0);
    }

    @Override
    public boolean removeInterval(int a, int b, SConstraint cause, boolean forceAwake) throws ContradictionException {
        return this.domain.removeInterval(a, b, cause, forceAwake);
    }

    @Override
    @Deprecated
    public boolean removeInterval(int a, int b, int idx) throws ContradictionException {
        return this.domain.removeInterval(a, b, this.getCause(idx), idx >= 0);
    }

    @Override
    public boolean instantiate(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        return this.domain.instantiate(x, cause, forceAwake);
    }

    @Override
    @Deprecated
    public boolean instantiate(int x, int idx) throws ContradictionException {
        return this.domain.instantiate(x, this.getCause(idx), idx < 0);
    }

    @Override
    public int getInf() {
        return this.domain.getInf();
    }

    @Override
    public int getSup() {
        return this.domain.getSup();
    }

    @Override
    public int getVal() {
        return this.domain.getInf();
    }

    @Override
    public int getValue() {
        return this.domain.getInf();
    }

    @Override
    public String toString() {
        return super.toString() + ':' + (this.isInstantiated() ? Integer.valueOf(this.getVal()) : "?");
    }

    @Override
    public String pretty() {
        return this.toString() + '[' + this.domain.getSize() + ']' + this.domain.pretty();
    }
}

