/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.cp.solver.constraints.set.SetEq;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.set.AbstractBinSetSConstraint;
import choco.kernel.solver.variables.set.SetVar;

public final class SetNotEq
extends AbstractBinSetSConstraint {
    public SetNotEq(SetVar sv1, SetVar sv2) {
        super(sv1, sv2);
    }

    public boolean checkAreEqual() throws ContradictionException {
        if (this.v0.isInstantiated() && this.v1.isInstantiated() && this.v0.getKernelDomainSize() == this.v1.getKernelDomainSize()) {
            DisposableIntIterator it1 = this.v0.getDomain().getKernelIterator();
            while (it1.hasNext()) {
                if (this.v1.isInDomainKernel(it1.next())) continue;
                it1.dispose();
                return false;
            }
            it1.dispose();
            this.fail();
        }
        return false;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 7;
    }

    public static boolean checkAreNotEqual(SetVar instVar, SetVar otherVar) {
        DisposableIntIterator it1 = instVar.getDomain().getKernelIterator();
        while (it1.hasNext()) {
            if (otherVar.isInDomainEnveloppe(it1.next())) continue;
            it1.dispose();
            return true;
        }
        it1.dispose();
        it1 = otherVar.getDomain().getKernelIterator();
        while (it1.hasNext()) {
            if (instVar.isInDomainEnveloppe(it1.next())) continue;
            it1.dispose();
            return true;
        }
        it1.dispose();
        return false;
    }

    public void filterForInst(SetVar instvar, SetVar otherVar, int idx) throws ContradictionException {
        int deltaSize = otherVar.getEnveloppeDomainSize() - otherVar.getKernelDomainSize();
        if (deltaSize == 0) {
            this.checkAreEqual();
        } else if (deltaSize == 1 && !SetNotEq.checkAreNotEqual(instvar, otherVar)) {
            if (otherVar.getEnveloppeDomainSize() > instvar.getKernelDomainSize()) {
                DisposableIntIterator it1 = otherVar.getDomain().getEnveloppeIterator();
                while (it1.hasNext()) {
                    int val = it1.next();
                    if (otherVar.isInDomainKernel(val)) continue;
                    otherVar.addToKernel(val, this, false);
                }
                it1.dispose();
            } else {
                DisposableIntIterator it1 = otherVar.getDomain().getEnveloppeIterator();
                while (it1.hasNext()) {
                    int val = it1.next();
                    if (otherVar.isInDomainKernel(val)) continue;
                    otherVar.remFromEnveloppe(val, this, false);
                }
                it1.dispose();
            }
        }
    }

    @Override
    public void awakeOnKer(int varIdx, int x) throws ContradictionException {
        if (varIdx == 0) {
            if (!this.v1.isInDomainEnveloppe(x)) {
                this.setPassive();
            } else if (this.v1.isInstantiated()) {
                this.filterForInst(this.v1, this.v0, 0);
            }
        } else if (!this.v0.isInDomainEnveloppe(x)) {
            this.setPassive();
        } else if (this.v0.isInstantiated()) {
            this.filterForInst(this.v0, this.v1, 1);
        }
    }

    @Override
    public void awakeOnEnv(int varIdx, int x) throws ContradictionException {
        if (varIdx == 0) {
            if (this.v1.isInDomainKernel(x)) {
                this.setPassive();
            } else if (this.v1.isInstantiated()) {
                this.filterForInst(this.v1, this.v0, 0);
            }
        } else if (this.v0.isInDomainKernel(x)) {
            this.setPassive();
        } else if (this.v0.isInstantiated()) {
            this.filterForInst(this.v0, this.v1, 1);
        }
    }

    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        if (varIdx == 0) {
            this.filterForInst(this.v0, this.v1, 1);
        } else {
            this.filterForInst(this.v1, this.v0, 0);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.v0.isInstantiated()) {
            this.filterForInst(this.v0, this.v1, 1);
        }
        if (this.v1.isInstantiated()) {
            this.filterForInst(this.v1, this.v0, 0);
        }
    }

    @Override
    public boolean isSatisfied() {
        if (this.v0.isInstantiated() && this.v1.isInstantiated()) {
            if (this.v0.getKernelDomainSize() == this.v1.getKernelDomainSize()) {
                DisposableIntIterator it1 = this.v0.getDomain().getKernelIterator();
                while (it1.hasNext()) {
                    if (this.v1.isInDomainKernel(it1.next())) continue;
                    it1.dispose();
                    return true;
                }
                it1.dispose();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isConsistent() {
        return this.isSatisfied();
    }

    @Override
    public String toString() {
        return this.v0 + " neq " + this.v1;
    }

    @Override
    public String pretty() {
        return this.v0.pretty() + " neq " + this.v1.pretty();
    }

    @Override
    public AbstractSConstraint<SetVar> opposite(Solver solver) {
        return new SetEq(this.v0, this.v1);
    }
}

