/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.branch;

import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.branch.AbstractIntBranchingStrategy;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.search.IntBranchingDecision;
import java.util.logging.Level;

public class BranchingWithLoggingStatements
extends AbstractIntBranchingStrategy {
    public final AbstractIntBranchingStrategy internalBranching;
    private int nextInformationNode = ChocoLogging.getEveryXNodes();

    public BranchingWithLoggingStatements(AbstractIntBranchingStrategy internalBranching) {
        this.internalBranching = internalBranching;
        this.setSolver(internalBranching.manager);
    }

    @Override
    public boolean finishedBranching(IntBranchingDecision decision) {
        return this.internalBranching.finishedBranching(decision);
    }

    @Override
    public String getDecisionLogMessage(IntBranchingDecision decision) {
        throw new SolverException("What are you doing ? It is the logging wrapper !");
    }

    public static final StringBuilder makeLoggingMsgPrefix(int worldStamp) {
        StringBuilder b = new StringBuilder();
        b.append(StringUtils.pad("", worldStamp, "."));
        b.append('[').append(worldStamp).append(']');
        return b;
    }

    protected String makeLoggingMessage(IntBranchingDecision decision, String dirMsg, int worldStamp) {
        StringBuilder b = BranchingWithLoggingStatements.makeLoggingMsgPrefix(worldStamp);
        b.append(' ').append(dirMsg);
        b.append(this.internalBranching.getDecisionLogMessage(decision));
        b.append(" branch ").append(decision.getBranchIndex());
        return new String(b);
    }

    @Override
    public void goDownBranch(IntBranchingDecision decision) throws ContradictionException {
        if (LOGGER.isLoggable(Level.INFO)) {
            if (this.manager.getNodeCount() >= this.nextInformationNode) {
                LOGGER.log(Level.INFO, "- Partial Search - {0}.", this.manager.partialRuntimeStatistics(false));
                this.nextInformationNode = this.manager.getNodeCount() + ChocoLogging.getEveryXNodes();
                ChocoLogging.flushLogs();
            }
            if (LOGGER.isLoggable(Level.CONFIG) && this.manager.solver.getWorldIndex() < ChocoLogging.getLoggingMaxDepth()) {
                LOGGER.log(Level.CONFIG, this.makeLoggingMessage(decision, "down branch ", this.manager.solver.getWorldIndex()));
                ChocoLogging.flushLogs();
            }
        }
        this.internalBranching.goDownBranch(decision);
    }

    @Override
    public void goUpBranch(IntBranchingDecision decision) throws ContradictionException {
        if (LOGGER.isLoggable(Level.CONFIG) && this.manager.solver.getWorldIndex() + 1 < ChocoLogging.getLoggingMaxDepth()) {
            LOGGER.log(Level.CONFIG, this.makeLoggingMessage(decision, "up branch ", this.manager.solver.getWorldIndex() + 1));
        }
        this.internalBranching.goUpBranch(decision);
    }

    @Override
    public void setFirstBranch(IntBranchingDecision decision) {
        this.internalBranching.setFirstBranch(decision);
    }

    @Override
    public void setNextBranch(IntBranchingDecision decision) {
        this.internalBranching.setNextBranch(decision);
    }

    @Override
    public Object selectBranchingObject() throws ContradictionException {
        return this.internalBranching.selectBranchingObject();
    }

    @Override
    public void initBranching() {
        super.initBranching();
        this.internalBranching.initBranching();
    }

    @Override
    public void initConstraintForBranching(SConstraint c) {
        super.initConstraintForBranching(c);
        this.internalBranching.initConstraintForBranching(c);
    }

    public static final AbstractIntBranchingStrategy setLoggingStatement(AbstractIntBranchingStrategy goal) {
        BranchingWithLoggingStatements res = new BranchingWithLoggingStatements(goal);
        if (goal.getNextBranching() != null) {
            if (goal.getNextBranching() instanceof AbstractIntBranchingStrategy) {
                res.setNextBranching(BranchingWithLoggingStatements.setLoggingStatement((AbstractIntBranchingStrategy)goal.getNextBranching()));
            } else {
                throw new SolverException("cant set logging statements");
            }
        }
        return res;
    }
}

