% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mathml.R
\name{mathout}
\alias{mathout}
\alias{inline}
\title{MathML or MathJax output, depending on the knitr context}
\usage{
mathout(term, flags = NULL, env = parent.frame())

inline(term, flags = NULL, env = parent.frame())
}
\arguments{
\item{term}{an R call or symbol/number. This function translates \emph{term} into a
LaTeX/MathJax string.}

\item{flags}{(default NULL)
list of flags that control the translation}

\item{env}{(default parent.frame())
The R environment in which r_eval is being executed (see vignette for
details, "Ringing back to R").}
}
\value{
A string with the MathML or MathJax representation of \emph{term}.
}
\description{
MathML or MathJax output, depending on the knitr context
}
\details{
This function checks knitr::is_html_output()
and knitr::is_html_output() and invokes the respective function mathml() or
mathjax(). Outside of knitr context, MathML is returned, and a warning is
given.
}
\examples{
mathout(term=quote((a + b)^2L == a^2L + 2L*a*b + b^2L))

inline(term=quote((a + b)^2L == a^2L + 2L*a*b + b^2L))

}
\seealso{
\code{\link[=mathml]{mathml()}}, \code{\link[=mathjax]{mathjax()}}, \code{\link[=inline]{inline()}}
}
