% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determinants.R
\name{row_cofactors}
\alias{row_cofactors}
\title{Row Cofactors of A[i,]}
\usage{
row_cofactors(A, i)
}
\arguments{
\item{A}{a square matrix}

\item{i}{row index}
}
\value{
a vector of the cofactors of A[i,]
}
\description{
Returns the vector of cofactors of row i of the square matrix A.  The determinant, \code{det(A)},
can then be found as \code{M[i,] \%*\% row_cofactors(M,i)} for any row, i.
}
\examples{
M <- matrix(c(4, -12, -4,
              2,   1,  3,
             -1,  -3,  2), 3, 3, byrow=TRUE)
minor(M, 1, 1)
minor(M, 1, 2)
minor(M, 1, 3)
row_cofactors(M, 1)
det(M)
# expansion by cofactors of row 1
M[1,] \%*\% row_cofactors(M,1)

}
\author{
Michael Friendly
}
\seealso{
\code{\link[base]{det}} for the determinant

Other determinants: \code{\link{cofactor}},
  \code{\link{minor}}, \code{\link{row_minors}}
}

