% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svdDemo.R
\name{svdDemo}
\alias{svdDemo}
\title{Demonstrate the SVD for a 3 x 3 matrix}
\usage{
svdDemo(A, shape = c("cube", "sphere"), alpha = 0.7,
  col = rainbow(6))
}
\arguments{
\item{A}{A 3 x 3 numeric matrix}

\item{shape}{Basic shape used to represent the identity matrix: \code{"cube"} or \code{"sphere"}}

\item{alpha}{transparency value used to draw the shape}

\item{col}{Vector of 6 colors for the faces of the basic cube}
}
\value{
Nothing
}
\description{
This function draws an \code{rgl} scene consisting of a representation of the identity matrix and a
3 x 3 matrix \code{A}, together with the corresponding representation of the
matrices U, D, and V in the SVD decomposition,
A = U D V'.
}
\examples{
A <- matrix(c(1,2,0.1, 0.1,1,0.1, 0.1,0.1,0.5), 3,3)
svdDemo(A)

\dontrun{
B <- matrix(c( 1, 0, 1, 0, 2, 0,  1, 0, 2), 3, 3)
svdDemo(B)

# a positive, semi-definite matrix with eigenvalues 12, 6, 0
C <- matrix(c(7, 4, 1,  4, 4, 4,  1, 4, 7), 3, 3)
svdDemo(C)
}

}
\author{
Original idea from Duncan Murdoch
}
