% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimeVariation.R
\name{detectTimeVariations}
\alias{detectTimeVariations}
\title{Detects items whose value (stock, demand, etc.) has changed over time}
\usage{
detectTimeVariations(
  data,
  value,
  item,
  timestamp,
  temporalAggregation = c("day", "week", "month", "quarter", "year"),
  aggregationFun = sum,
  preProcess = NA,
  recentTimePeriods = 5
)
}
\arguments{
\item{data}{Data frame that will be expanded.}

\item{value}{Name of the column variable that contains the value for the ABC and XYZ analysis.}

\item{item}{Name of the column including the item names or identifiers (e.g., product name, EAN)}

\item{timestamp}{Name of the column including the timestamp. This column should be in POSIX or Date-format.}

\item{temporalAggregation}{Temporal aggregation mode (i.e., "day", "week", "month", "quarter", "year").}

\item{aggregationFun}{Function for aggregating the value column. Default is sum.}

\item{preProcess}{A string vector that defines a pre-processing of the aggregated data before clustering.
Available pre-processing methods are "center", "scale", "standardize", and "normalize". Default is NA (no pre-processing).}

\item{recentTimePeriods}{Integer indicating the number of time periods that are used to define the recent
item values. Default is 5.}
}
\value{
Returns a data frame showing to which cluster each item belongs based on all value and based on the recent values
as well as whether the item has switched the cluster.
}
\description{
Detects items whose value (stock, demand, etc.) has changed over time in contrast to other items.
This analysis is based on the Macnaughton-Smith et al. clustering algorithm.
}
\examples{
data("Amount")
timeVariations = detectTimeVariations(data = Amount,
    value = "amount",
    item = "item",
    timestamp = "date",
    temporalAggregation = "week")
}
\references{
Macnaughton-Smith, P., Williams, W.T., Dale, M.B., Mockett, L.G. (1964)
"Dissimilarity Analysis: a new Technique of Hierarchical Sub-division",
\emph{Nature}, \strong{202}, 1034--1035.
}
