% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_filter.R
\name{sim_filter_all_same}
\alias{sim_filter_all_same}
\title{Filter a melted similarity matrix to keep pairs with the same
values in specific columns.}
\usage{
sim_filter_all_same(
  sim_df,
  row_metadata,
  all_same_cols,
  annotation_cols = NULL,
  include_group_tag = FALSE,
  drop_lower = FALSE,
  sim_cols = c("id1", "id2", "sim")
)
}
\arguments{
\item{sim_df}{data.frame with melted similarity matrix.}

\item{row_metadata}{data.frame with row metadata.}

\item{all_same_cols}{character vector specifying columns.}

\item{annotation_cols}{optional character vector specifying which columns
from \code{metadata} to annotate the left index of the filtered
\code{sim_df} with.}

\item{include_group_tag}{optional boolean specifying whether to include an
identifier for the pairs using the values in the \code{all_same_cols}
columns.}

\item{drop_lower}{optional boolean specifying whether to drop the pairs
where the first index is smaller than the second index. This is equivalent
to dropping the lower triangular of  \code{sim_df}.}

\item{sim_cols}{optional character string specifying minimal set of columns
for a similarity matrix}
}
\value{
Filtered \code{sim_df} as a data.frame, where only pairs with the
same values in \code{all_same_cols} columns are kept. Rows are annotated
based on the first index, if specified.
}
\description{
\code{sim_filter_all_same} filters a melted similarity matrix to keep pairs
with the same values in specific columns.
}
\examples{
suppressMessages(suppressWarnings(library(magrittr)))
n <- 5
population <- tibble::tibble(
  Metadata_group = sample(c("a", "b"), n, replace = TRUE),
  Metadata_type = sample(c("x", "y"), n, replace = TRUE),
  x = rnorm(n),
  y = x + rnorm(n) / 100,
  z = y + rnorm(n) / 1000
)
annotation_cols <- c("Metadata_group", "Metadata_type")
sim_df <- matric::sim_calculate(population, method = "pearson")
row_metadata <- attr(sim_df, "row_metadata")
sim_df <- matric::sim_annotate(sim_df, row_metadata, annotation_cols)
all_same_cols <- c("Metadata_group")
include_group_tag <- TRUE
drop_lower <- FALSE
matric::sim_filter_all_same(
  sim_df,
  row_metadata,
  all_same_cols,
  annotation_cols,
  include_group_tag,
  drop_lower
)
}
