% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccc_repeated.R
\name{summary.ccc_lmm_reml}
\alias{summary.ccc_lmm_reml}
\title{Summary Method for \code{ccc_lmm_reml} Objects}
\usage{
\method{summary}{ccc_lmm_reml}(
  object,
  digits = 4,
  ci_digits = 2,
  show_ci = c("auto", "yes", "no"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{"ccc_lmm_reml"}, as returned by \code{\link[=ccc_lmm_reml]{ccc_lmm_reml()}}.}

\item{digits}{Integer; number of decimal places to round CCC estimates and components.}

\item{ci_digits}{Integer; decimal places for confidence interval bounds.}

\item{show_ci}{Character string indicating whether to show confidence intervals:
\code{"auto"} (default) shows only if non-NA CIs exist, \code{"yes"} always shows CIs,
\code{"no"} never shows them.}

\item{...}{Additional arguments (ignored).}
}
\value{
A data frame of class \code{"summary.ccc_lmm_reml"} with columns:
\code{method1}, \code{method2}, \code{estimate}, and optionally \code{lwr}, \code{upr},
as well as variance component estimates: \code{sigma2_subject}, \code{sigma2_subject_method},
\code{sigma2_subject_time}, \code{sigma2_error}, \code{sigma2_extra}, \code{SB}, \code{se_ccc}.
}
\description{
Produces a detailed summary of a \code{"ccc_lmm_reml"} object, including
Lin's CCC estimates and associated variance component estimates per method pair.
}
