% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixpls.optim.R
\name{optimCrit}
\alias{optimCrit}
\alias{optimCrit.maximizeInnerR2}
\alias{optimCrit.maximizeIndicatorR2}
\alias{optimCrit.maximizeFullR2}
\alias{optimCrit.gsca}
\title{Optimization criteria functions}
\usage{
optimCrit.maximizeInnerR2(matrixpls.res)

optimCrit.maximizeIndicatorR2(matrixpls.res)

optimCrit.maximizeFullR2(matrixpls.res)

optimCrit.gsca(matrixpls.res)
}
\arguments{
\item{matrixpls.res}{An object of class \code{matrixpls} from which the
criterion function is calculated}
}
\value{
Value of the optimization criterion.
}
\description{
Optimization criterion functions calculate various optimization criterion values
from \code{matrixpls} objects.
}
\section{Functions}{
\itemize{
\item \code{optimCrit.maximizeInnerR2}: maximizes the sum of R2 statistics of the \code{inner} matrix

\item \code{optimCrit.maximizeIndicatorR2}: maximizes the sum of R2 statistics of the \code{reflective} matrix.

\item \code{optimCrit.maximizeFullR2}: maximizes the sum of R2 statistics of the \code{inner} and \code{reflective} matrices.

\item \code{optimCrit.gsca}: minimizes the generalized structured component analysis criterion. See \link{GSCA}
}}

\seealso{
\code{\link{weightFun.optim}}
}
