% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{aggregate_pieces_byname}
\alias{aggregate_pieces_byname}
\title{Aggregate a matrix by pieces of row and/or column names}
\usage{
aggregate_pieces_byname(
  a,
  piece,
  margin = c(1, 2),
  notation,
  prepositions = RCLabels::prepositions,
  aggregation_map = NULL,
  pattern_type = "exact"
)
}
\arguments{
\item{a}{A matrix or list of matrices}

\item{piece}{See \code{rename_to_piece_byname()}.}

\item{margin}{See \code{rename_to_piece_byname()}.}

\item{notation}{See \code{rename_to_piece_byname()}.}

\item{prepositions}{See \code{rename_to_piece_byname()}.}

\item{aggregation_map}{See \code{aggregate_byname()}.}

\item{pattern_type}{See \code{RCLabels::make_or_pattern()}.}
}
\value{
A version of \code{a} with rows and/or columns aggregated according to \code{aggregation_map}.
}
\description{
Aggregate a matrix (or list of matrices or a column in a \code{matsindf} data frame)
by pieces of the row and column names.
}
\details{
This is a convenience function that bundles two others
for common use cases:
\code{rename_to_piece_byname()} followed by \code{aggregate_byname()}.

\code{aggregation_map} should aggregate according to pieces,
not according to the full, original row and/or column names.
}
\examples{
a <- matrix(c(1, 2, 3, 
              4, 5, 6), nrow = 2, ncol = 3, byrow = TRUE, 
            dimnames = list(c("a [from b]", "c [from d]"), 
                            c("e [from f]", "g [from h]", "i [from j]")))
a \%>\%
  aggregate_pieces_byname(piece = "suff", 
                          notation = RCLabels::from_notation,
                          aggregation_map = list(rows = c("b", "d"), 
                                                 cols = c("h", "j")))
m <- matrix(c(1, 0, 0, 
              0, 1, 1, 
              0, 1, 1), nrow = 3, ncol = 3, byrow = TRUE, 
            dimnames = list(c("Gasoline [from Oil refineries]", 
                              "Electricity [from Main activity producer electricity plants]", 
                              "Electricity [from Hydro]"),
                            c("Automobiles", "LED lamps", "CFL lamps"))) \%>\%
  setrowtype("Product") \%>\% setcoltype("Industry")
mT <- transpose_byname(m)
# Aggregate the "Electricity" rows.
aggregate_pieces_byname(m, piece = "noun", margin = "Product",
                        notation = RCLabels::bracket_notation)
# Also works in a list.
aggregate_pieces_byname(a = list(m, mT), piece = "noun", 
                        margin = "Product",
                        notation = RCLabels::bracket_notation)
# Use an aggregation map
aggregate_pieces_byname(a = list(m, mT), piece = "noun", 
                        margin = "Product",
                        aggregation_map = list(list(final = c("Electricity", "Gasoline"))),
                        notation = RCLabels::bracket_notation)
# Also works in a data frame.
df <- tibble::tibble(m = list(m, mT), 
                     pce = "noun",
                     mgn = "Product",
                     agg_map = list(list(final = c("Electricity", "Gasoline"))), 
                     notn = list(RCLabels::bracket_notation)) \%>\%
  dplyr::mutate(
    agg = aggregate_pieces_byname(a = m, piece = pce, margin = mgn, 
                                  aggregation_map = agg_map,
                                  notation = notn)
  )
df$agg
}
