% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{create_matrix_byname}
\alias{create_matrix_byname}
\title{Create a "byname" matrix from a vector}
\usage{
create_matrix_byname(
  .dat,
  nrow,
  ncol,
  byrow = FALSE,
  dimnames,
  matrix.class = lifecycle::deprecated(),
  matrix_class = c("matrix", "Matrix")
)
}
\arguments{
\item{.dat}{The data to be used to create the matrix, in a list format, or as a data frame column
containing a list of the data to be used for each observation.}

\item{nrow}{The number of rows to be used to create the matrix, in a list format, or as a data frame column
containing a list of the number of rows to be used for each observation.}

\item{ncol}{The number of columns to be used to create the matrix, in a list format, or as a data frame column
containing a list of the number of columns to be used for each observation.}

\item{byrow}{The argument stating whether the matrix should be filled by rows or by columns (FALSE by column, TRUE by row),
in a list format, or as a data frame column containing a list of the byrow argument for each observation.
Default is \code{FALSE.}}

\item{dimnames}{The dimension names to be used for creating the matrices, in a list format, or as a data frame column
containing a list of the dimension names to be used for each observation.}

\item{matrix.class}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{matrix_class} instead.}

\item{matrix_class}{One of "matrix" or "Matrix".
"matrix" creates a \code{base::matrix} object with the \code{matrix()} function.
"Matrix" creates a \code{Matrix::Matrix} object using the \code{matsbyname::Matrix()} function.
This could be a sparse matrix.
Default is "matrix".}
}
\value{
A matrix, list of matrices, or column in a data frame, depending on the input arguments.
}
\description{
This function creates a "byname" matrix, or list of matrices, from \code{.dat},
depending on the input arguments.
This function is similar to \code{matrix()}, but with "byname" characteristics.
}
\details{
Row and column names are taken from the \code{dimnames} argument.

Any row or column type information on \code{.dat} is preserved on output.

The created object(s) can be of type \code{base::matrix} or \code{Matrix::Matrix},
the latter enables sparse objects to save both memory and disk.
}
\examples{
create_matrix_byname(c(1, 2), nrow = 2, ncol = 1,
                     dimnames = list(c("r1", "r2"), "c1"))
create_matrix_byname(list(1, 2), nrow = list(1, 1), ncol = list(1,1), 
                     dimnames = list(list("r1", "c1"), list("R1", "C1")))
}
