% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{create_rowvec_byname}
\alias{create_rowvec_byname}
\title{Create row vectors from data}
\usage{
create_rowvec_byname(
  .dat,
  dimnames = NA,
  rowname = NA,
  matrix.class = lifecycle::deprecated(),
  matrix_class = c("matrix", "Matrix")
)
}
\arguments{
\item{.dat}{Data to be converted to row vectors.}

\item{dimnames}{The dimension names to be used for creating the row vector, in a list format, or as a data frame column
containing a list of the dimension names to be used for each observation.}

\item{rowname}{The name of the row of the row vector.}

\item{matrix.class}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{matrix_class} instead.}

\item{matrix_class}{One of "matrix" or "Matrix".
"matrix" creates a \code{base::matrix} object with the \code{matrix()} function.
"Matrix" creates a \code{Matrix::Matrix} object using the \code{matsbyname::Matrix()} function.
This could be a sparse matrix.
Default is "matrix".}
}
\value{
A row vector, a list of row vectors, or a data frame column of row vectors, depending on the
values of \code{.dat} and \code{class}.
}
\description{
This function takes data in the \code{.dat} and creates row vectors.
}
\details{
The row and column names in the resulting row vector are taken from
\code{rowname} and the names of \code{.dat}.
If set, \code{dimnames} overrides \code{rowname} and the names of \code{.dat}.

Row types and column types are taken from the row type and column type attributes of \code{.dat}.

This function is a "byname" function that can accept a single number,
a vector, a list, or a data frame in \code{.dat}.
}
\examples{
# Works with single numbers
create_rowvec_byname(c(c1 = 1) \%>\% setrowtype("rt") \%>\% setcoltype("ct"), rowname = "r1")
# Works with vectors
create_rowvec_byname(c(c1 = 1, c2 = 2), rowname = "r1")
# Works with a list
create_rowvec_byname(list(c(c1 = 1, c2 = 2), c(C1 = 3, C2 = 4, C3 = 5)), 
                     rowname = list("r1", "R1"))
# Works in a tibble, too.
# (Must be a tibble, not a data frame, so that names are preserved.)
dat <- list(c(c1 = 1),
            c(C1 = 2, C2 = 3), 
            c(c1 = 1, c2 = 2, c3 = 3, c4 = 4, c5 = 5, c6 = 6))
rnms <- list("r1", "R1", "r1")
df1 <- tibble::tibble(dat, rnms)
df1
df1 <- df1 \%>\%
  dplyr::mutate(
    rowvec_col = create_rowvec_byname(dat, rowname = rnms)
  )
df1$rowvec_col[[1]]
df1$rowvec_col[[2]]
df1$rowvec_col[[3]]
}
