% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{matrix_cols}
\alias{matrix_cols}
\title{Find columns that contain matrices}
\usage{
matrix_cols(.df, .drop_names = FALSE, .any = FALSE)
}
\arguments{
\item{.df}{The data frame to be queried for matrix columns.}

\item{.drop_names}{A boolean that tells whether to remove the names from
the returned integer vector.
Default is \code{FALSE}.}

\item{.any}{A boolean that tells whether a column is reported when
\code{any()} of the rows contain matrices
(instead of \code{all()} rows contain matrices).
Default is \code{FALSE}, in which case
all entries in a column must be a matrix for
the column to be reported.}
}
\value{
A vector of integers saying which columns contain matrices.
}
\description{
It is often helpful to find the columns of a \code{matsindf}
data frame that contain exclusively or some matrices.
This function helps with that task.
}
\details{
By default, a column is considered a matrix column if \code{all()} of the
rows contain matrices.
Use the \code{.test_any} argument to modify this behavior.

By default, the vector of integers returned from this function
is named by the columns.
Use the \code{.drop_names} function to modify this behavior.
}
\examples{
tidy <- tibble::tibble(matrix = c("V1", "V1", "V1", "V2", "V2"),
                         row = c("i1", "i1", "i2", "i1", "i2"),
                         col = c("p1", "p2", "p2", "p1", "p2"),
                         vals = c(1, 2, 3, 4, 5)) \%>\%
  dplyr::mutate(
    rowtypes = "Industries",
    coltypes  = "Products"
  ) \%>\%
  dplyr::group_by(matrix)
matsdf <- tidy \%>\%
  collapse_to_matrices(matnames = "matrix", matvals = "vals",
                       rownames = "row", colnames = "col",
                       rowtypes = "rowtypes", coltypes = "coltypes")
matsdf
matrix_cols(matsdf)
matrix_cols(matsdf, .drop_names = TRUE)
}
