% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mauricer.R
\docType{package}
\name{mauricer}
\alias{mauricer}
\title{mauricer: Install BEAST2 packages.}
\description{
'BEAST2' (<http://www.beast2.org>) is a widely used
Bayesian phylogenetic tool, that uses DNA/RNA/protein data
and many model priors to create a posterior of jointly estimated
phylogenies and parameters.
}
\details{
'BEAST2' is commonly accompanied by 'BEAUti 2' (<http://www.beast2.org>),
which, among others, allows one to install 'BEAST2' package.
This package allows to install 'BEAST2' packages from 'R'.

* \link{get_beast2_pkg_names}: get the names of all BEAST2 packages
* \link{install_beast2_pkg}: install a BEAST2 package
* \link{is_beast2_pkg_installed}: determine if a BEAST2 package is installed
* \link{uninstall_beast2_pkg}: uninstall a BEAST2 package
}
\seealso{
\link{mauricer} is part of the \code{babette} package suite:
\itemize{
  \item{
    \code{babette}: work with BEAST2
  }
  \item{
    \link[beautier]{beautier}: create BEAST2 input files
  }
  \item{
    \link[beastier]{beastier}: run BEAST2
  }
  \item{
    \link{mauricer}: install BEAST2 packages
  }
  \item{
    \link[tracerer]{tracerer}: parse and analyse BEAST2 output
  }
}
}
