% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbr.R
\name{mbr}
\alias{mbr}
\title{Compute and Visualize Biomarker Ordinal Estimator}
\usage{
mbr(df)
}
\arguments{
\item{df}{a data frame with the name of experimental groups or biomonitoring
sites as the first column and the measurement of biomarkers as the
remaining columns.}
}
\value{
\code{mbr} returns a list of length 3: \item{\code{iBOE}}{a data
  frame with 14 columns:\describe{ \item{\code{treatment}}{treatment groups
  or test sites} \item{\code{control}}{control group or reference site}
  \item{\code{tm_size}}{the sample size of treatment group}
  \item{\code{ct_size}}{the sample size of control group}
  \item{\code{biomarker}}{individual biomarker} \item{\code{delta}}{the
  Cliff's delta of treatment group} \item{\code{ci.lower}}{the lower bound of
  the confidence interval} \item{\code{ci.upper}}{the uppper bound of the
  confidence interval} \item{\code{Opt}}{the Biomarker Ordinal Estimator for
  individual biomarker (iBOE) in optimistic scenario} \item{\code{Pro}}{the
  Biomarker Ordinal Estimator for individual biomarker (iBOE) in probable
  scenario} \item{\code{Pes}}{the Biomarker Ordinal Estimator for individual
  biomarker (iBOE) in pessimistic scenario} \item{\code{optimistic}}{the
  perceived difference in optimistic scenario} \item{\code{probable}}{the
  perceived difference in probable scenario} \item{\code{pessimistic}}{the
  perceived difference in pessimistic scenario}}} \item{\code{BOE}}{a data
  frame with 7 columns:\describe{ \item{\code{treatment}}{treatment groups or
  test sites} \item{\code{Opt}}{the Biomarker Ordinal Estimator for combined
  biomarker (BOE) in optimistic scenario} \item{\code{Pro}}{the Biomarker
  Ordinal Estimator for combined biomarker (BOE) in probable scenario}
  \item{\code{Pes}}{the Biomarker Ordinal Estimator for combined biomarker
  (BOE) in pessimistic scenario} \item{\code{optimistic}}{the perceived
  difference in optimistic scenario} \item{\code{probable}}{the perceived
  difference in probable scenario} \item{\code{pessimistic}}{the perceived
  difference in pessimistic scenario} }} \item{\code{heatmap}}{a ggplot
  object containing 4 heatmaps of the perceived differences}
}
\description{
\code{mbr} calculates the Biomarker Ordinal Estimator (BOE) and visualizes
the perceived differences.
}
\details{
The header of the first column can be any character, for example,
  'group' or 'site'. The first name appearing in the first column will
  determine the control group or the reference site. The other names will be
  treatment groups or test sites. The header of the remaining columns will
  define the list of biomarkers.
}
\examples{
\donttest{mbr(sokolova2019)} #might take more than 5s in some machines

}
