% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_example.R
\name{run_example}
\alias{run_example}
\title{run_example for Model-Based BE Assessment}
\usage{
run_example(run_dir, nmfe_path, Include_R_Code = FALSE, plan = "multisession")
}
\arguments{
\item{run_dir}{Character string specifying the directory containing the parent folder where the models are to be run.}

\item{nmfe_path}{Character string indicating the path to the nmfe batch file (e.g., nmfe?.bat).}

\item{Include_R_Code}{Logical, whether the include the code in R_Penalty_Code in model averaging algorithm, Default is FALSE}

\item{plan}{for future execution, one of "sequential", "multisession","multicore", Default is multisession}
}
\value{
A list containing:
\itemize{
\item \code{Cmax_power}: Power for Cmax
\item \code{AUClast_power}: Power for AUClast
\item \code{AUCinf_power}: Power for AUCinf
\item \code{run_dir}: Directory where the function was executed
\item \code{Num_identifiable}: Number of identifiable parameters
\item \code{BICS}: Bayesian Information Criterion Scores
}
}
\description{
This function calls the example models (model1-5.mod), performs the bootstrap, model averaging and the Monte Carlo simulation.
}
\details{
The function executes the mbbe::run_mbbe_json() function. A user supplied installation of NONMEM is required
run_dir is the parent folder where the models are to be run, nmfe_path is the path the nmfe??.bat where ?? is the version of NONMEM available
plan is "sequential", "multisession","multicore", defining the plan for parallel execution (sequential is non-parallel execution)
The function uses the included file mbbeargs.json as the options file for the run, and runs 5 supplied models for model averaging.
Monte Carlo Simulation is then done, with the number of samples set in the mbbearg.json file, to 10 (probaby more would be appropriate for
and actual power analysis)
The model selection for the model averaging also includes a penalty calculate by the script RPenaltyCode.r for missing Cmax, AUCinf and AUClast
Run time on 32 cores is ~3 minutes without the R code execution an 10 minutes with
and the output should include:
}
\examples{
\dontrun{
run_dir <- tempdir()
mbbe::run_example(run_dir = run_dir,
  nmfe_path = "c:/nm74g64/util/nmfe74.bat",
  plan = "multisession")
}
}
