% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MbgModelRunner.R
\name{MbgModelRunner}
\alias{MbgModelRunner}
\title{MBG model runner class}
\description{
R6 class to run a full MBG model and make predictions.
}
\details{
To see examples of this object, run \code{vignette('mbg')}
}
\concept{model_runner}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{input_data}}{(\link[data.table:data.table]{data.table::data.table})\cr
Table containing at least the following fields:\cr
\itemize{
\item x (\code{numeric}) location longitude in decimal degrees\cr
\item y (\code{numeric}) location latitude in decimal degrees\cr
\item indicator (\code{integer}) The number of events in the population\cr
\item samplesize (\code{integer}) The total population, denominator for \code{indicator}
}}

\item{\code{id_raster}}{(\link[terra:SpatRaster-class]{terra::SpatRaster})\cr
raster showing the total area that will be predicted using this model.}

\item{\code{covariate_rasters}}{(\code{list()})\cr
A list containing all predictor covariates. Each covariate is a
\link[terra:SpatRaster-class]{terra::SpatRaster} object with the same extent and dimensions as
\code{id_raster}.}

\item{\code{aggregation_table}}{(\link[data.table:data.table]{data.table::data.table})\cr
A table created by \link{build_aggregation_table}, used to link each grid cell to
higher-level administrative units.}

\item{\code{aggregation_levels}}{(\code{list()})\cr
A named list: for each named item, the name is the label for that aggregation
level, and the value is a character vector of all fields in the original polygons
to be used for aggregation at that level.}

\item{\code{population_raster}}{(\link[terra:SpatRaster-class]{terra::SpatRaster})\cr
A raster giving population for each grid cell, to be used for population-weighted
aggregation from grid cells to polygon boundaries. Should have the same dimensions
as \code{id_raster}. If no population raster is passed and the results are aggregated,
aggregation will be by simple mean rather than population-weighted mean}

\item{\code{admin_bounds}}{(\link[sf:sf]{sf::sf})\cr
Polygons showing the boundaries of administrative divisions within the study
region. Only required if \code{use_admin_effect} OR \code{stacking_use_admin_bounds} is
\code{TRUE}.}

\item{\code{admin_bounds_id}}{(\code{character})\cr
Field containing unique identifiers for \code{admin_bounds}, if passed.}

\item{\code{use_covariates}}{(\code{logical(1)})\cr
Should covariate effects be included in the predictive model?}

\item{\code{use_gp}}{(\code{logical(1)})\cr
Should a smoothed spatial surface be included in the predictive model?}

\item{\code{use_admin_effect}}{(\code{logical(1)})\cr
Should IID administrative-level effects be included in the predictive model?}

\item{\code{use_nugget}}{(\code{logical(1)})\cr
Should an IID effect by pixel be included in the predictive model?}

\item{\code{use_stacking}}{(\code{logical(1)})\cr
Should machine learning submodels be trained to relate the covariate rasters with
the outcome data? Only run if \code{use_covariates} is \code{TRUE}.}

\item{\code{stacking_model_settings}}{(\code{list()})\cr
A named list of submodels to be run. For more information about this term, see
\link{run_regression_submodels}. Only considered if \code{use_stacking} is TRUE.}

\item{\code{stacking_cv_settings}}{(\code{list()})\cr
How should the stacking submodels be cross-validated? For more information about
this term, see \link{run_regression_submodels}. Only considered if \code{use_stacking} is
\code{TRUE}.}

\item{\code{stacking_use_admin_bounds}}{(\code{logical(1)})\cr
Should admin boundaries be included as features in the stacking submodels? For more
information about this term, see \link{run_regression_submodels}. Only considered if
\code{use_stacking} is TRUE.}

\item{\code{stacking_prediction_range}}{(\code{logical(1)})\cr
Range of possible predictions for the stacking submodels. For more information
about this term, see \link{run_regression_submodels}. Only considered if
\code{use_stacking} is TRUE.}

\item{\code{mesh_max_edge}}{(\code{numeric(2)} or NULL)\cr
Maximum size of the INLA SPDE mesh inside (1) and outside (2) of the modeled
region. Only considered if \code{use_gp} is TRUE.}

\item{\code{mesh_cutoff}}{(\code{numeric(1)})\cr
Minimum size of the INLA mesh, usually reached in data-dense areas. Only considered
if \code{use_gp} is TRUE.}

\item{\code{spde_integrate_to_zero}}{(\code{boolean(1)})\cr
Should the 'volume' under the SPDE mesh integrate to zero? Only considered if
\code{use_gp} is TRUE.}

\item{\code{prior_spde_range}}{(\code{list()})\cr
A named list specifying the penalized complexity prior for the SPDE range. The two
named items are "threshold", the test threshold (set as a proportion of the
overall mesh extent), and "prob_below", the prior probability that the value is
BELOW that range threshold. The function automatically converts "threshold" from
a proportion of the overall mesh extent into a distance. Only considered if
\code{use_gp} is TRUE.}

\item{\code{prior_spde_sigma}}{(\code{list()})\cr
A named list specifying the penalized complexity prior for sigma (standard
deviation) of the SPDE object. The two named items are "threshold", the test
threshold for the standard deviation, and "prob_above", the prior probability
that sigma will EXCEED that threshold. Only considered if \code{use_gp} is TRUE}

\item{\code{prior_nugget}}{(\code{list()})\cr
A named list specifying the penalized complexity prior for the nugget term. The two
named items are "threshold", the test threshold for the nugget standard
deviation, and "prob_above", the prior probability that the standard deviation
will EXCEED that threshold. Only considered if \code{use_nugget} is TRUE.}

\item{\code{prior_admin_effect}}{(\code{list()})\cr
A named list specifying the penalized complexity prior for the admin-level IID
term. The two named items are "threshold", the test threshold for the standard
deviation of admin-level effects, and "prob_above", the prior probability that
the standard deviation will EXCEED that threshold. Only considered if
\code{use_admin_effect} is TRUE.}

\item{\code{prior_covariate_effect}}{(\code{list()})\cr
A named list specifying the penalized complexity prior for all covariate effects
except for the intercept, if an intercept is included. The two named items are
"threshold", the test threshold for the size of each fixed effect, and
"prob_above", the prior probability that the beta for each covariate will EXCEED
that threshold. Only considered if \code{use_covariates} is TRUE and \code{use_stacking} is
FALSE.}

\item{\code{inla_link}}{(\code{character(1)})\cr
Link function for fitting the INLA model, typically related to the GLM \code{family}.}

\item{\code{inverse_link}}{(\code{character(1)})\cr
Inverse function of \code{inla_link}.}

\item{\code{inla_family}}{(character)\cr
GLM family to use. For more information, see \link[stats:family]{stats::family}.}

\item{\code{nugget_in_predict}}{(\code{logical(1)})\cr
If the nugget is used in model fitting, should it also be included as an IID effect
by pixel in the model prediction step?}

\item{\code{verbose}}{Should model progress be timed?}

\item{\code{model_covariates}}{(\code{list()})\cr
A list of covariates to be included in the INLA model. Either equal to
\code{covariate_rasters}, or ML model predictions for stacked generalization.}

\item{\code{inla_inputs_list}}{(\code{list()})\cr
List of model inputs yielded by \link{prepare_inla_data_stack}}

\item{\code{inla_fitted_model}}{(\code{list()})\cr
List of model outputs yielded by \link{fit_inla_model}}

\item{\code{grid_cell_predictions}}{List of predictive surfaces yielded by \link{generate_cell_draws_and_summarize}}

\item{\code{aggregated_predictions}}{List of predictions by administrative unit. Only created if \code{aggregation_table} and
\code{aggregation_levels} are both defined.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MbgModelRunner-new}{\code{MbgModelRunner$new()}}
\item \href{#method-MbgModelRunner-prepare_covariates}{\code{MbgModelRunner$prepare_covariates()}}
\item \href{#method-MbgModelRunner-fit_mbg_model}{\code{MbgModelRunner$fit_mbg_model()}}
\item \href{#method-MbgModelRunner-generate_predictions}{\code{MbgModelRunner$generate_predictions()}}
\item \href{#method-MbgModelRunner-aggregate_predictions}{\code{MbgModelRunner$aggregate_predictions()}}
\item \href{#method-MbgModelRunner-run_mbg_pipeline}{\code{MbgModelRunner$run_mbg_pipeline()}}
\item \href{#method-MbgModelRunner-get_predictive_validity}{\code{MbgModelRunner$get_predictive_validity()}}
\item \href{#method-MbgModelRunner-clone}{\code{MbgModelRunner$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MbgModelRunner-new"></a>}}
\if{latex}{\out{\hypertarget{method-MbgModelRunner-new}{}}}
\subsection{Method \code{new()}}{
Create a new MbgModelRunner object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MbgModelRunner$new(
  input_data,
  id_raster,
  covariate_rasters = NULL,
  aggregation_table = NULL,
  aggregation_levels = NULL,
  population_raster = NULL,
  admin_bounds = NULL,
  admin_bounds_id = NULL,
  use_covariates = TRUE,
  use_gp = TRUE,
  use_admin_effect = FALSE,
  use_nugget = TRUE,
  use_stacking = FALSE,
  stacking_cv_settings = list(method = "repeatedcv", number = 5, repeats = 5),
  stacking_model_settings = list(gbm = NULL, treebag = NULL, rf = NULL),
  stacking_use_admin_bounds = FALSE,
  stacking_prediction_range = NULL,
  mesh_max_edge = c(0.2, 5),
  mesh_cutoff = c(0.04),
  spde_integrate_to_zero = FALSE,
  prior_spde_range = list(threshold = 0.1, prob_below = 0.05),
  prior_spde_sigma = list(threshold = 3, prob_above = 0.05),
  prior_nugget = list(threshold = 3, prob_above = 0.05),
  prior_admin_effect = list(threshold = 3, prob_above = 0.05),
  prior_covariate_effect = list(threshold = 3, prob_above = 0.05),
  inla_link = "logit",
  inverse_link = "plogis",
  inla_family = "binomial",
  nugget_in_predict = TRUE,
  verbose = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input_data}}{(\link[data.table:data.table]{data.table::data.table}) Table containing at least
the following fields:\cr
\itemize{
\item x (\code{numeric}) location x position, in the same projection as the \code{id_raster}\cr
\item y (\code{numeric}) location y position, in the same projection as the \code{id_raster}\cr
\item indicator (\code{integer}) The number of events in the population\cr
\item samplesize (\code{integer}) The total population, denominator for \code{indicator}\cr
}}

\item{\code{id_raster}}{(\link[terra:SpatRaster-class]{terra::SpatRaster}) raster showing the total area that
will be predicted using this model}

\item{\code{covariate_rasters}}{(\code{list()}, default NULL) A list containing all predictor
covariates. Each covariate is a \link[terra:SpatRaster-class]{terra::SpatRaster} object with the same extent
and dimensions as \code{id_raster}.}

\item{\code{aggregation_table}}{(\link[data.table:data.table]{data.table::data.table}) A table created by
\link{build_aggregation_table}, linking each grid cell to one or more polygons}

\item{\code{aggregation_levels}}{(\code{list()}) A named list: for each named item, the name is
the label for that aggregation level, and the value is a character vector of all
fields in the original polygons to be used for aggregation at that level.}

\item{\code{population_raster}}{(\link[terra:SpatRaster-class]{terra::SpatRaster}) A raster giving population for each
grid cell, to be used for population-weighted aggregation from grid cells to
polygon boundaries. Should have the same dimensions as \code{id_raster}. If no
population raster is passed and the results are aggregated, aggregation will be by
simple mean rather than population-weighted mean}

\item{\code{admin_bounds}}{(\link[sf:sf]{sf::sf}, default \code{NULL}) Polygons showing the boundaries
of administrative divisions within the study region. Only required if
\code{use_admin_effect} OR \code{stacking_use_admin_bounds} is \code{TRUE}.}

\item{\code{admin_bounds_id}}{(\code{character}, default \code{NULL}) Field containing unique
identifiers for \code{admin_bounds}, if passed.}

\item{\code{use_covariates}}{(\code{logical(1)}, default TRUE) Should covariate effects be
included in the predictive model?}

\item{\code{use_gp}}{(\code{logical(1)}, default TRUE) Should a smoothed spatial surface be
included in the predictive model?}

\item{\code{use_admin_effect}}{(\code{logical(1)} default FALSE) Should IID
administrative-level effects be included in the predictive model?}

\item{\code{use_nugget}}{(\code{logical(1)}, default TRUE) Should an IID effect by pixel be
included in the predictive model?}

\item{\code{use_stacking}}{(\code{logical(1)}, default FALSE) Should machine learning submodels
be trained to relate the covariate rasters with the outcome data? Only run if
\code{use_covariates} is \code{TRUE}.}

\item{\code{stacking_cv_settings}}{(\code{list()}) How should the stacking submodels be
cross-validated? For more information about this term, see
\link{run_regression_submodels}. Only considered if \code{use_stacking} is \code{TRUE}.}

\item{\code{stacking_model_settings}}{(\code{list()}) A named list of submodels to be run. For
more information about this term, see \link{run_regression_submodels}. Only considered
if \code{use_stacking} is TRUE.}

\item{\code{stacking_use_admin_bounds}}{(\code{logical(1)}, default FALSE) Should admin
boundaries be included as features in the stacking submodels? For more
information about this term, see \link{run_regression_submodels}. Only considered if
\code{use_stacking} is TRUE.}

\item{\code{stacking_prediction_range}}{(\code{numeric(2)}, default NULL) Range of possible
predictions for the stacking submodels. For more information about this term, see
\link{run_regression_submodels}. Only considered if \code{use_stacking} is TRUE.}

\item{\code{mesh_max_edge}}{(\code{numeric(2)}, default c(0.2, 5)) Maximum size of the INLA
SPDE mesh inside (1) and outside (2) of the modeled region. Only considered if
\code{use_gp} is TRUE.}

\item{\code{mesh_cutoff}}{(\code{numeric(1)}, default 0.04) Minimum size of the INLA mesh,
usually reached in data-dense areas. Only considered if \code{use_gp} is TRUE.}

\item{\code{spde_integrate_to_zero}}{(\code{boolean(1)}, default FALSE) Should the 'volume'
under the SPDE mesh integrate to zero? Only considered if \code{use_gp} is TRUE.}

\item{\code{prior_spde_range}}{(\code{list()}) A named list specifying the penalized complexity
prior for the SPDE range. The two named items are "threshold", the test threshold
(set as a proportion of the overall mesh extent), and "prob_below", the prior
probability that the value is BELOW that range threshold. The function
automatically converts "threshold" from a proportion of the overall mesh extent
into a distance. Only considered if \code{use_gp} is TRUE.}

\item{\code{prior_spde_sigma}}{(\code{list()}) A named list specifying the penalized complexity
prior for sigma (standard deviation) of the SPDE object. The two named items are
"threshold", the test threshold for the standard deviation, and "prob_above",
the prior probability that sigma will EXCEED that threshold. Only considered if
\code{use_gp} is TRUE}

\item{\code{prior_nugget}}{(\code{list()}) A named list specifying the penalized complexity
prior for the nugget term. The two named items are "threshold", the test
threshold for the nugget standard deviation, and "prob_above", the prior
probability that the standard deviation will EXCEED that threshold. Only
considered if \code{use_nugget} is TRUE.}

\item{\code{prior_admin_effect}}{(\code{list()}) A named list specifying the penalized
complexity prior for the admin-level IID term. The two named items are
"threshold", the test threshold for the standard deviation of admin-level
effects, and "prob_above", the prior probability that the standard deviation will
EXCEED that threshold. Only considered if \code{use_admin_effect} is TRUE.}

\item{\code{prior_covariate_effect}}{(\code{list()}) A named list specifying the penalized
complexity prior for all covariate effects except for the intercept, if an
intercept is included. The two named items are "threshold", the test threshold
for the size of each fixed effect, and "prob_above", the prior probability that
the beta for each covariate will exceed that threshold. Only considered if
\code{use_covariates} is TRUE and \code{use_stacking} is FALSE.}

\item{\code{inla_link}}{(\code{character(1)}, default 'logit') Link function for fitting the
INLA model, typically related to the GLM \code{family}.}

\item{\code{inverse_link}}{(\code{character(1)}, default 'plogis') Inverse function of
\code{inla_link}.}

\item{\code{inla_family}}{(\code{character(1)}, default 'binomial') GLM family to use. For more
information, see \code{\link[stats:family]{stats::family()}}.}

\item{\code{nugget_in_predict}}{(\code{logical(1)}, default TRUE) If the nugget is used in
model fitting, should it also be included as an IID effect by pixel in the
model prediction step?}

\item{\code{verbose}}{(\code{logical(1)}, default TRUE) Should model progress be timed?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MbgModelRunner-prepare_covariates"></a>}}
\if{latex}{\out{\hypertarget{method-MbgModelRunner-prepare_covariates}{}}}
\subsection{Method \code{prepare_covariates()}}{
Prepare covariates for MBG model fitting
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MbgModelRunner$prepare_covariates()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MbgModelRunner-fit_mbg_model"></a>}}
\if{latex}{\out{\hypertarget{method-MbgModelRunner-fit_mbg_model}{}}}
\subsection{Method \code{fit_mbg_model()}}{
Fit MBG model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MbgModelRunner$fit_mbg_model()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MbgModelRunner-generate_predictions"></a>}}
\if{latex}{\out{\hypertarget{method-MbgModelRunner-generate_predictions}{}}}
\subsection{Method \code{generate_predictions()}}{
Generate predictions by grid cell
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MbgModelRunner$generate_predictions(n_samples = 1000, ui_width = 0.95)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_samples}}{(\code{integer(1)}, default 1000) Number of posterior predictive
samples to generate from the fitted model object.}

\item{\code{ui_width}}{(\code{numeric(1)}, default 0.95) Uncertainty interval width. This
method will create summary rasters for quantiles ((1 - ui_width)/2) and
(1 - (1 - ui_width)/2).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MbgModelRunner-aggregate_predictions"></a>}}
\if{latex}{\out{\hypertarget{method-MbgModelRunner-aggregate_predictions}{}}}
\subsection{Method \code{aggregate_predictions()}}{
Aggregate grid cell predictions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MbgModelRunner$aggregate_predictions(ui_width = 0.95)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ui_width}}{(\code{numeric(1)}, default 0.95) Uncertainty interval width. This
method will create summary "upper" and "lower" fields rasters for quantiles
((1 - ui_width)/2) and (1 - (1 - ui_width)/2).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List with the same names as \code{self$aggregation_levels}, aggregating by the
columns specified in \code{self$aggregation_levels}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MbgModelRunner-run_mbg_pipeline"></a>}}
\if{latex}{\out{\hypertarget{method-MbgModelRunner-run_mbg_pipeline}{}}}
\subsection{Method \code{run_mbg_pipeline()}}{
Run a full MBG pipeline, including stacking, MBG model fitting, and prediction
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MbgModelRunner$run_mbg_pipeline(n_samples = 1000, ui_width = 0.95)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_samples}}{(\code{integer(1)}, default 1000) Number of posterior predictive
samples to generate from the fitted model object.}

\item{\code{ui_width}}{(\code{numeric(1)}, default 0.95)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MbgModelRunner-get_predictive_validity"></a>}}
\if{latex}{\out{\hypertarget{method-MbgModelRunner-get_predictive_validity}{}}}
\subsection{Method \code{get_predictive_validity()}}{
Get predictive validity metrics for the fitted model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MbgModelRunner$get_predictive_validity(
  in_sample = TRUE,
  validation_data = NULL,
  na.rm = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{in_sample}}{(\code{logical(1)}, default TRUE) Compare model predictions to
the data used to generate the model? If FALSE, does not return the WAIC, which
is only useful for in-sample predictive validity.}

\item{\code{validation_data}}{(\link[data.table:data.table]{data.table::data.table}, default NULL) Observed data to
compare against. Expected for out-of-sample model validation. Table containing at
least the following fields:\cr
\itemize{
\item x (\code{numeric}) location x position, in the same projection as the \code{id_raster}\cr
\item y (\code{numeric}) location y position, in the same projection as the \code{id_raster}\cr
\item indicator (\code{integer}) The number of events in the population\cr
\item samplesize (\code{integer}) The total population, denominator for \code{indicator}
}}

\item{\code{na.rm}}{(\code{logical(1)}, default FALSE) Should NA values be dropped from the
RMSE and log predictive density calculations?}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Returns the point RMSE (compared against the mean estimates by pixel),
log-posterior density (compared against the predictive draws), and the
Watanabe-Aikake Information Criterion (WAIC, only returned for in-sample
predictive validity).
}

\subsection{Returns}{
\link[data.table:data.table]{data.table::data.table} Containing the following fields:\cr
\itemize{
\item 'rmse': Root mean squared error when compared against the mean estimates by
pixel. Lower RMSE is better.\cr
\item 'lpd': Log posterior predictive density when compared against pixel-level
samples from the model. Higher LPD is better.\cr
\item 'waic' (in-sample only): Watanable-Aikake information criterion estimated by
INLA. Lower WAIC is better.\cr
For clarity, these fields will have the suffix "_is" for in-sample models, and
"_oos" for out-of-sample models.
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MbgModelRunner-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MbgModelRunner-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MbgModelRunner$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
