% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_covariates.R
\name{load_covariates}
\alias{load_covariates}
\title{Load covariates}
\usage{
load_covariates(
  directory,
  covariates_table,
  id_raster,
  year = NULL,
  file_format = "tif",
  add_intercept = FALSE,
  check_previous_years = 10
)
}
\arguments{
\item{directory}{Directory containing all covariate sub-directories}

\item{covariates_table}{\code{data.frame} containing at least the following fields:
\itemize{
\item 'covariate': (character): Name of the covariate
\item 'annual': (logical) Does the covariate vary by year? If so, look for the \code{year} in
the name of the file.
\item 'transform': (character) Name of a function to use to transform the covariate.
Common options include 'identity' (no transformation), 'sqrt', 'abs', and 'log1p'
\item 'normalize': (logical) Should the covariate be rescaled to have mean 0 and standard
deviation 1 across all pixels in the study area? Generally should be set to TRUE
for predictive covariates.
}}

\item{id_raster}{\link[terra:SpatRaster-class]{terra::SpatRaster} with non-NA pixels delineating the extent of the
study area}

\item{year}{(\code{numeric}, default NULL) Year of data to for time-varying covariates.
If NULL, the default, uses the current year.}

\item{file_format}{(\code{character}, default 'tif') File format for the raster covariate
data. Used to search for the input file within the proper containing folder.}

\item{add_intercept}{(\code{logical}, default FALSE) Should a covariate called "intercept",
a raster object with 1s in all required cells, be placed at the start of the returned
covariates list?}

\item{check_previous_years}{(\code{integer} > 0, default 10) If annual data is not found in
this year, how many previous years should be checked? If 0, will not check any
previous years.}
}
\value{
A named list of formatted covariates. Each list item is a \link[terra:SpatRaster-class]{terra::SpatRaster}
with one layer and the same dimensions as the \code{id_raster}
}
\description{
Load covariates
}
\details{
Load a list of covariates from a specified directory structure
}
\concept{core_inputs}
