% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_inla_data_stack.R
\name{prepare_inla_data_stack}
\alias{prepare_inla_data_stack}
\title{Prepare data stack for INLA}
\usage{
prepare_inla_data_stack(
  input_data,
  id_raster,
  covariates,
  use_covariates = TRUE,
  covariates_sum_to_one = FALSE,
  family = "binomial",
  use_spde = TRUE,
  spde_range_pc_prior = list(threshold = 0.1, prob_below = 0.05),
  spde_sigma_pc_prior = list(threshold = 3, prob_above = 0.05),
  spde_integrate_to_zero = TRUE,
  mesh_max_edge = c(0.2, 5),
  mesh_cutoff = 0.04,
  use_nugget = TRUE,
  nugget_pc_prior = list(threshold = 3, prob_above = 0.05),
  use_admin_effect = FALSE,
  admin_boundaries = NULL,
  admin_pc_prior = list(threshold = 3, prob_above = 0.05)
)
}
\arguments{
\item{input_data}{A data.frame with at least the following columns:
\itemize{
\item 'indicator': number of "hits' per site, e.g. tested positive for malaria
\item 'samplesize': total population sampled at the site
\item 'x': x position, often longitude
\item 'y': y position, often latitude
}}

\item{id_raster}{\link[terra:SpatRaster-class]{terra::SpatRaster} with non-NA pixels delineating the extent of the
study area}

\item{covariates}{(list) Named list of all covariate effects included in the model,
typically generated by \code{\link[=load_covariates]{load_covariates()}}. Only used if \code{use_covariates} is TRUE.}

\item{use_covariates}{(\code{boolean(1)}, default TRUE) Should covariate fixed effects be
included in the model? If TRUE, includes fixed effects for all covariates in the
\code{covariates} argument. If FALSE, includes only an intercept.}

\item{covariates_sum_to_one}{(logical, default FALSE) Should the input covariates be
constrained to sum to one? Usually FALSE when raw covariates are passed to the model,
and TRUE if running an ensemble (stacking) model.}

\item{family}{(\code{character(1)}, default 'binomial') Statistical family; used to
link stacked covariates with outcomes}

\item{use_spde}{(\code{boolean(1)}, default TRUE) Should an SPDE approximation of a Gaussian
process be included in the model?}

\item{spde_range_pc_prior}{(list) A named list specifying the penalized complexity
prior for the SPDE range. The two named items are "threshold", the test threshold
(set as a proportion of the overall mesh extent), and "prob_below", the prior
probability that the value is BELOW that range threshold. The function automatically
converts "threshold" from a proportion of the overall mesh extent into a distance.}

\item{spde_sigma_pc_prior}{(list) A named list specifying the penalized complexity
prior for sigma (standard deviation) of the SPDE object. The two named items are
"threshold", the test threshold for the standard deviation, and "prob_above",
the prior probability that sigma will EXCEED that threshold.}

\item{spde_integrate_to_zero}{(\code{boolean(1)}, default TRUE) Should the 'volume' under
the SPDE mesh integrate to zero?}

\item{mesh_max_edge}{(\code{numeric(2)}, default c(0.2, 5)) Maximum size of the INLA SPDE
mesh inside (1) and outside (2) of the modeled region.}

\item{mesh_cutoff}{(\code{numeric(1)}, default 0.04) Minimum size of the INLA mesh, usually
reached in data-dense areas.}

\item{use_nugget}{(\code{boolean(1)}, default TRUE) Should a nugget (IID observation-level
error or noise) term be included?}

\item{nugget_pc_prior}{A named list specifying the penalized complexity prior for the
nugget term. The two named items are "threshold", the test threshold for the nugget
standard deviation, and "prob_above", the prior probability that the standard
deviation will EXCEED that threshold. Only used if \code{use_nugget} is TRUE}

\item{use_admin_effect}{(\code{boolean(1)}, default FALSE) Should an IID random effect by
administrative unit be included?}

\item{admin_boundaries}{(\link[sf:sf]{sf} object, default NULL) admin boundaries spatial
object. Only used if \code{use_admin_effect} is TRUE}

\item{admin_pc_prior}{(list) A named list specifying the penalized complexity prior
for the admin-level IID term. The two named items are "threshold", the test threshold
for the standard deviation of admin-level effects, and "prob_above", the prior
probability that the standard deviation will EXCEED that threshold. Only used if
\code{use_admin_effect} is TRUE.}
}
\value{
List containing the following items:
\itemize{
\item "mesh": The mesh used to approximate the latent Gaussian process
\item "spde": The SPDE object that will be used to fit the INLA model
\item "inla_data_stack": The data stack to be passed to \code{INLA::inla()}
\item "formula_string": The formula specification to be passed to \code{INLA::inla()}
}
}
\description{
Prepare data stack for INLA
}
\details{
Creates the formatted input data to be used by the INLA model. For more
information about penalized complexity priors, see Daniel Simpson's
paper on the subject: \doi{doi:10.1214/16-STS576}
}
\seealso{
\code{\link[=fit_inla_model]{fit_inla_model()}} \link{MbgModelRunner}
}
\concept{model_fit}
