% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swc_ind.R
\name{swc_ind}
\alias{swc_ind}
\title{Smallest Worthwhile Change: Individual}
\usage{
swc_ind(x, swc, type = c("previous", "trend"), ts, te, main, xlab, ylab)
}
\arguments{
\item{x}{numeric vectors of data values}

\item{swc}{smallest worthwhile change}

\item{type}{(character) indicator specifying which type of analysis: "previous" or "trend"}

\item{ts}{(required if \code{type = "trend"}) target slope}

\item{te}{(optional) typical error. Defaults to typical error of the estimate}

\item{main}{(optional) plot title. Defaults to blank}

\item{xlab}{(optional) x-axis label. Defaults to "Measurement"}

\item{ylab}{(optional) y-axis label. Defaults to name of \code{x}}
}
\description{
Provides longitudinal magnitude-based inferences for an individual's change from previous time point and magnitude of deviation from trend line.
}
\details{
Refer to vignette for further information.
}
\examples{
df<-c(97.5,99.9,100.2,101,101.2,99.8)

swc_ind(x = df, swc = 0.5, te = 1, ts = 0.25, type = "trend")
}
\references{
Hopkins WG. (2017). A spreadsheet for monitoring an individual's changes and trend. \emph{Sportscience} 21, 5-9. sportsci.org/2017/wghtrend.htm
}
