% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_stat_rs.R
\name{cor_stat_rs}
\alias{cor_stat_rs}
\title{Calculate general stationary correlation.}
\usage{
cor_stat_rs(
  n_regime,
  base_ls,
  lagrangian_ls,
  par_base_ls,
  par_lagr_ls,
  lambda_ls,
  h_ls,
  h1_ls,
  h2_ls,
  u_ls,
  base_fixed = FALSE
)
}
\arguments{
\item{n_regime}{Integer, number of regimes.}

\item{base_ls}{List of base model, \code{sep} or \code{fs} for now. Or list of
correlation matrices/arrays.}

\item{lagrangian_ls}{List of Lagrangian model, \code{lagr_tri} or \code{lagr_askey}
for now.}

\item{par_base_ls}{List of parameters for the base model, used only when
\code{base_fixed = FALSE}.}

\item{par_lagr_ls}{List of parameters for the Lagrangian model.  Used only
when \code{lagrangian_ls} is not \code{none}.}

\item{lambda_ls}{List of weight of the Lagrangian term,
\eqn{\lambda\in[0, 1]}.}

\item{h_ls}{List of Euclidean distance matrix or array,
used only when \code{base_fixed = FALSE}.}

\item{h1_ls}{List of horizontal distance matrix or array, same dimension as
\code{h_ls}. Used only when \code{lagrangian_ls} is not \code{none}.}

\item{h2_ls}{List of vertical distance matrix or array, same dimension as
\code{h_ls}. Used only when \code{lagrangian_ls} is not \code{none}.}

\item{u_ls}{List of time lag, same dimension as \code{h_ls}.}

\item{base_fixed}{Logical; if TRUE, \code{base_ls} is the list of correlation.}
}
\value{
Correlations for the general stationary model. Same dimension of
\code{base_ls} if \code{base_fixed = TRUE}.
}
\description{
Calculate general stationary correlation.
}
\details{
It gives a list of general stationary correlation for \code{n_regime}
regimes. See \link{cor_stat} for the model details. Model parameters are lists of
length 1 or \code{n_regime}. When length is 1, same values are used for all
regimes. If \code{base_fixed = TRUE}, the base is a list of correlation and
\code{par_base_ls} and \code{h_ls} are not used.
}
\examples{
# Fit general stationary model with sep base.
par_s <- list(nugget = 0.5, c = 0.01, gamma = 0.5)
par_t <- list(a = 1, alpha = 0.5)
par_base <- list(par_s = par_s, par_t = par_t)
h1 <- array(c(0, 5, -5, 0), dim = c(2, 2, 3))
h2 <- array(c(0, 8, -8, 0), dim = c(2, 2, 3))
h <- sqrt(h1^2 + h2^2)
u <- array(rep(c(1, 2, 3), each = 4), dim = c(2, 2, 3))
cor_stat_rs(
    n_regime = 2,
    base_ls = list("sep"),
    lagrangian_ls = list("none", "lagr_tri"),
    par_base_ls = list(par_base),
    par_lagr_ls = list(NULL, list(v1 = 10, v2 = 20)),
    lambda_ls = list(0, 0.2),
    h_ls = list(h),
    h1_ls = list(NULL, h1),
    h2_ls = list(NULL, h2),
    u_ls = list(u, u + 1)
)

# Fit general stationary model given fs as the base model.
h1 <- array(c(0, 5, -5, 0), dim = c(2, 2, 3))
h2 <- array(c(0, 8, -8, 0), dim = c(2, 2, 3))
h <- sqrt(h1^2 + h2^2)
u <- array(rep(c(0.1, 0.2, 0.3), each = 4), dim = c(2, 2, 3))
fit_base <- cor_fs(
    nugget = 0.5, c = 0.01, gamma = 0.5, a = 1, alpha = 0.5,
    beta = 0.0, h = h, u = u
)
par_lagr <- list(v1 = 5, v2 = 10)
cor_stat_rs(
    n_regime = 2,
    par_lagr_ls = list(par_lagr),
    h1_ls = list(h1),
    h2_ls = list(h2),
    u_ls = list(u, u + 1),
    lambda_ls = list(0, 0.8),
    base_ls = list(fit_base),
    lagrangian = list("lagr_tri", "lagr_askey"),
    base_fixed = TRUE
)

}
\seealso{
Other correlation functions: 
\code{\link{cor_cauchy}()},
\code{\link{cor_exp}()},
\code{\link{cor_fs}()},
\code{\link{cor_lagr_askey}()},
\code{\link{cor_lagr_tri}()},
\code{\link{cor_sep}()},
\code{\link{cor_stat}()}
}
\concept{correlation functions}
