% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_lagr.R
\name{fit_lagr.mcgf_rs}
\alias{fit_lagr.mcgf_rs}
\title{Parameter estimation for Lagrangian correlation functions for an \code{mcgf_rs}
object.}
\usage{
\method{fit_lagr}{mcgf_rs}(
  x,
  model_ls,
  method_ls = "wls",
  optim_fn_ls = "nlminb",
  par_fixed_ls = list(NULL),
  par_init_ls,
  lower_ls = list(NULL),
  upper_ls = list(NULL),
  other_optim_fn_ls = list(NULL),
  dists_base_ls,
  dists_lagr_ls = list(NULL),
  rs = TRUE,
  ...
)
}
\arguments{
\item{x}{An \code{mcgf_rs} object containing attributes \code{dists}, \code{acfs}, \code{ccfs},
and \code{sds}. \code{x} must have been passed to \code{add_base()} or \verb{base<-}}

\item{model_ls}{List of base models, each element must be one of \code{lagr_tri},
\code{lagr_askey}, or \code{none}. If \code{none}, NULLs are returned.}

\item{method_ls}{List of parameter estimation methods, weighted least square
(\code{wls}) or maximum likelihood estimation (\code{mle}).}

\item{optim_fn_ls}{List of optimization functions, each element must be one
of \code{nlminb}, \code{optim}, \code{other}. When use \code{other}, supply \code{other_optim_fn_ls}}

\item{par_fixed_ls}{List of fixed parameters.}

\item{par_init_ls}{List of initial values for parameters to be optimized.}

\item{lower_ls}{Optional; list of lower bounds of parameters.}

\item{upper_ls}{Optional: list of upper bounds of parameters.}

\item{other_optim_fn_ls}{Optional, list of other optimization functions. The
first two arguments must be initial values for the parameters and a function
to be minimized respectively (same as that of \code{optim} and \code{nlminb}).}

\item{dists_base_ls}{List of lists of distance matrices. If NULL, \code{dists(x)}
is used. Each element must be a matrix or an array of distance matrices.}

\item{dists_lagr_ls}{List of distance matrices/arrays. Used when
\code{dists_base} is FALSE. If NULL, \code{dists(x)} is used.}

\item{rs}{Logical; if TRUE \code{x} is treated as a regime-switching, FALSE if the
parameters need to be estimated in a non-regime-switching setting.}

\item{...}{Additional arguments passed to \code{optim_fn}.}
}
\value{
A list containing outputs from optimization functions of \code{optim_fn}.
}
\description{
Parameter estimation for Lagrangian correlation functions for an \code{mcgf_rs}
object.
}
\details{
This functions is the regime-switching variant of \code{\link[=fit_lagr.mcgf]{fit_lagr.mcgf()}}.
Arguments are in lists. The length of arguments that end in \verb{_ls} must be 1
or the same as the number of regimes in \code{x}. If the length of an argument is
1, then it is set the same for all regimes. Refer to \code{\link[=fit_lagr.mcgf]{fit_lagr.mcgf()}} for
more details of the arguments.

Note that both \code{wls} and \code{mle} are heuristic approaches when \code{x} contains
observations from a subset of the discrete spatial domain, though estimation
results are close to that using the full spatial domain for large sample
sizes.

Since parameters for the base model and the Lagrangian model are estimated
sequentially, more accurate estimation may be obtained if the full model is
fitted all at once.
}
\examples{
data(sim3)
sim3_mcgf <- mcgf_rs(sim3$data, dists = sim3$dists, label = sim3$label)
sim3_mcgf <- add_acfs(sim3_mcgf, lag_max = 5)
sim3_mcgf <- add_ccfs(sim3_mcgf, lag_max = 5)

# Fit a fully symmetric model with known variables
fit_fs <- fit_base(
    sim3_mcgf,
    lag_ls = 5,
    model_ls = "fs",
    rs = FALSE,
    par_init_ls = list(list(beta = 0)),
    par_fixed_ls = list(list(
        nugget = 0,
        c = 0.05,
        gamma = 0.5,
        a = 0.5,
        alpha = 0.2
    ))
)

# Set beta to 0 to fit a separable model with known variables
fit_fs[[1]]$fit$par <- 0

# Store the fitted separable model to 'sim3_mcgf'
sim3_mcgf <- add_base(sim3_mcgf, fit_base_ls = fit_fs)

# Fit a regime-switching Lagrangian model.
fit_lagr_rs <- fit_lagr(
    sim3_mcgf,
    model_ls = list("lagr_tri"),
    par_init_ls = list(
        list(v1 = -50, v2 = 50),
        list(v1 = 100, v2 = 100)
    ),
    par_fixed_ls = list(list(lambda = 0.2, k = 2))
)
lapply(fit_lagr_rs[1:2], function(x) x$fit)
}
\seealso{
Other functions on fitting an mcgf_rs: 
\code{\link{add_base.mcgf_rs}()},
\code{\link{add_lagr.mcgf_rs}()},
\code{\link{fit_base.mcgf_rs}()},
\code{\link{krige.mcgf_rs}()}
}
\concept{functions on fitting an mcgf_rs}
