% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_ns.R
\name{mc_ns}
\alias{mc_ns}
\title{Non-structure Model Structure}
\source{
Bonat, W. H. (2018). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, 84(4):1--30.
}
\usage{
mc_ns(id, data, group = NULL, marca = NULL)
}
\arguments{
\item{id}{name of the column (string) containing the subject index.
Note this structure was designed to deal with longitudinal data.
For times series or spatial data use the same id for all observations
(one unit sample).}

\item{data}{data set.}

\item{group}{name of the column (string) containing a group specific
for which the covariance should change.}

\item{marca}{level (string) of the column group for which the
covariance should change.}
}
\value{
A list of a n*(n-1)/2 matrices.
}
\description{
The function \code{mc_non} builds the components
of the matrix linear predictor used for fitting non-structured
covariance matrix. In general this model is hard to fit due to the
large number of parameters.
}
\seealso{
\code{mc_id}, \code{mc_dglm}, \code{mc_dist}, \code{mc_ma},
\code{mc_rw} \cr and \code{mc_mixed}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
