% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCsim.R
\name{posterior-moments}
\alias{posterior-moments}
\alias{get_means}
\alias{get_sds}
\title{Get means or standard deviations of parameters from the MCMC output in an mcdraws object}
\usage{
get_means(obj, vnames = NULL)

get_sds(obj, vnames = NULL)
}
\arguments{
\item{obj}{an object of class \code{mcdraws}.}

\item{vnames}{optional character vector to select a subset of parameters.}
}
\value{
A list with simulation means or standard deviations.
}
\description{
Get means or standard deviations of parameters from the MCMC output in an mcdraws object
}
\examples{
\donttest{
ex <- mcmcsae_example(n=50)
sampler <- create_sampler(ex$model, data=ex$dat)
sim <- MCMCsim(sampler, burnin=100, n.iter=300, thin=2, n.chain=4)
get_means(sim)
get_means(sim, "e_")
sim <- MCMCsim(sampler, burnin=100, n.iter=300, thin=2, n.chain=4,
  store.mean=c("beta", "u"), store.sds=TRUE)
summary(sim, "beta")
get_means(sim, "beta")
get_sds(sim, "beta")
get_means(sim, "u")
get_sds(sim, "u")
}

}
