% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/so.R
\name{so}
\alias{so}
\title{Compute MCTQ local time of sleep onset}
\usage{
so(sprep, slat)
}
\arguments{
\item{sprep}{An \code{\link[hms:hms]{hms}} object corresponding to the \strong{local time
of preparing to sleep} from a standard or shift version of the MCTQ
questionnaire.}

\item{slat}{A \code{\link[lubridate:duration]{Duration}} object corresponding to the
\strong{sleep latency or time to fall asleep after preparing to sleep} from a
standard or shift version of the MCTQ questionnaire.}
}
\value{
An \code{\link[hms:hms]{hms}} object corresponding to the vectorized sum of
\code{sprep} and \code{slat} in a circular time frame of 24 hours.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

\code{so()} computes the \strong{local time of sleep onset} for standard and shift
versions of the Munich ChronoType Questionnaire (MCTQ).

Note that this value is collected directly from the questionnaire if you're
using the \eqn{\mu}MCTQ.
}
\details{
\strong{Standard MCTQ} functions were created following the guidelines in
Roenneberg, Wirz-Justice, & Merrow (2003), Roenneberg, Allebrandt, Merrow, &
Vetter (2012), and from The Worldwide Experimental Platform (theWeP, n.d.).

\strong{\eqn{\mu}MCTQ} functions were created following the guidelines in Ghotbi
et al. (2020), in addition to the guidelines used for the standard MCTQ.

\strong{MCTQ\eqn{^{Shift}}{ Shift}} functions were created following the
guidelines in Juda, Vetter, & Roenneberg (2013), in addition to the
guidelines used for the standard MCTQ.

See the References section to learn more.
\subsection{Class requirements}{

The \code{mctq} package works with a set of object classes specially created to
hold time values. These classes can be found in the
\link[lubridate:lubridate-package]{lubridate} and \link[hms:hms-package]{hms}
packages. Please refer to those package documentations to learn more about
them.
}

\subsection{Rounding and fractional time}{

Some operations may produce an output with fractional time (e.g.,
\code{"19538.3828571429s (~5.43 hours)"}, \code{01:15:44.505}). If you want, you
can round it with \code{\link[=round_time]{round_time()}}.

Our recommendation is to avoid rounding, but, if you do, make sure that you
only round your values after all computations are done. That way you avoid
\href{https://en.wikipedia.org/wiki/Round-off_error}{round-off errors}.
}
}
\section{Guidelines}{


Roenneberg, Allebrandt, Merrow, & Vetter (2012), Juda, Vetter, & Roenneberg
(2013), and The Worldwide Experimental Platform (n.d.) guidelines for \code{so()}
(\eqn{SO}) computation are as follows.
\subsection{Notes}{
\itemize{
\item This computation must be applied to each section of the questionnaire.
\item If you are visualizing this documentation in plain text, you may have some
trouble understanding the equations. You can see this documentation on the
package \href{https://docs.ropensci.org/mctq/reference/}{website}.
}
}

\subsection{For standard and micro versions of the MCTQ}{

\strong{\deqn{SPrep_{W/F} + SLat_{W/F}}{SPrep_W/F + SLat_W/F}}

Where:
\itemize{
\item \eqn{SPrep_{W/F}}{SPrep_W/F} = Local time of preparing to sleep on work
\strong{or} work-free days ("I actually get ready to fall asleep at ___ o'clock").
\item \eqn{SLat_{W/F}}{SLat_W/F} = Sleep latency or time to fall asleep after
preparing to sleep on work \strong{or} work-free days ("I need ___ min to fall
asleep").
}

\strong{*} \eqn{W} = Workdays; \eqn{F} = Work-free days.
}

\subsection{For the shift version of the MCTQ}{

\strong{\deqn{SPrep_{W/F}^{M/E/N} + SLat_{W/F}^{M/E/N}}{SPrep_W/F_M/E/N +
SLat_W/F_M/E/N}}

Where:
\itemize{
\item \eqn{SPrep_{W/F}^{M/E/N}}{SPrep_W/F_M/E/N} = Local time of preparing to
sleep between two days in a particular shift \strong{or} between two free days
after a particular shift ("I actually get ready to fall asleep at ___
o'clock").
\item \eqn{SLat_{W/F}^{M/E/N}}{SLat_W/F_M/E/N} = Sleep latency or time to fall
asleep after preparing to sleep between two days in a particular shift \strong{or}
between two free days after a particular shift ("I need ___ min to fall
asleep").
}

\strong{*} \eqn{W} = Workdays; \eqn{F} = Work-free days, \eqn{M} =
Morning shift; \eqn{E} = Evening shift; \eqn{N} = Night shift.
}
}

\examples{
## Scalar example

sprep <- hms::parse_hm("22:00")
slat <- lubridate::dminutes(15)
so(sprep, slat)
#> 22:15:00 # Expected

sprep <- hms::parse_hm("23:30")
slat <- lubridate::dminutes(45)
so(sprep, slat)
#> 00:15:00 # Expected

sprep <- hms::parse_hm("20:45")
slat <- lubridate::as.duration(NA)
so(sprep, slat)
#> NA # Expected

## Vector example

sprep <- c(hms::parse_hm("21:30"), hms::parse_hm("22:15"))
slat <- c(lubridate::dminutes(45), lubridate::dminutes(5))
so(sprep, slat)
#> 22:15:00 # Expected
#> 22:20:00 # Expected
}
\references{
Ghotbi, N., Pilz, L. K., Winnebeck, E. C., Vetter, C., Zerbini, G., Lenssen,
D., Frighetto, G., Salamanca, M., Costa, R., Montagnese, S., & Roenneberg, T.
(2020). The \eqn{\mu}MCTQ: an ultra-short version of the Munich ChronoType
Questionnaire. \emph{Journal of Biological Rhythms}, \emph{35}(1), 98-110.
\doi{10.1177/0748730419886986}.

Juda, M., Vetter, C., & Roenneberg, T. (2013). The Munich ChronoType
Questionnaire for shift-workers (MCTQ\eqn{^{Shift}}{ Shift}). \emph{Journal of
Biological Rhythms}, \emph{28}(2), 130-140. \doi{10.1177/0748730412475041}.

Roenneberg T., Allebrandt K. V., Merrow M., & Vetter C. (2012). Social jetlag
and obesity. \emph{Current Biology}, \emph{22}(10), 939-43.
\doi{10.1016/j.cub.2012.03.038}.

Roenneberg, T., Wirz-Justice, A., & Merrow, M. (2003). Life between clocks:
daily temporal patterns of human chronotypes. \emph{Journal of Biological
Rhythms}, \emph{18}(1), 80-90. \doi{10.1177/0748730402239679}.

The Worldwide Experimental Platform (n.d.). MCTQ.
\url{https://www.thewep.org/documentations/mctq/}
}
\seealso{
Other MCTQ functions: 
\code{\link{fd}()},
\code{\link{gu}()},
\code{\link{le_week}()},
\code{\link{msf_sc}()},
\code{\link{msl}()},
\code{\link{napd}()},
\code{\link{sd24}()},
\code{\link{sd_overall}()},
\code{\link{sd_week}()},
\code{\link{sdu}()},
\code{\link{sjl_sc}()},
\code{\link{sjl_weighted}()},
\code{\link{sjl}()},
\code{\link{tbt}()}
}
\concept{MCTQ functions}
