% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alt_plot.R, R/ggplot_mcvis.R, R/igraph_mcvis.R,
%   R/plot.mcvis.R
\name{alt_mcvis}
\alias{alt_mcvis}
\alias{ggplot_mcvis}
\alias{igraph_mcvis}
\alias{plot.mcvis}
\title{Multi-collinearity Visualization plots}
\usage{
alt_mcvis(mcvis_result, eig_max = 1L, var_max = ncol(mcvis_result$MC))

ggplot_mcvis(
  mcvis_result,
  eig_max = 1L,
  var_max = ncol(mcvis_result$MC),
  label_dodge = FALSE
)

igraph_mcvis(mcvis_result, eig_max = 1L, var_max = ncol(mcvis_result$MC))

\method{plot}{mcvis}(
  x,
  type = c("ggplot", "igraph", "alt"),
  eig_max = 1L,
  var_max = ncol(x$MC),
  label_dodge = FALSE,
  ...
)
}
\arguments{
\item{mcvis_result}{Output of the mcvis function}

\item{eig_max}{The maximum number of eigenvalues to be displayed on the plot.}

\item{var_max}{The maximum number of variables to be displayed on the plot.}

\item{label_dodge}{If variable names are too long, it might be helpful to dodge the labelling. Default to FALSE.}

\item{x}{Output of the mcvis function}

\item{type}{Plotting mcvis result using "igraph" or "ggplot". Default to "ggplot".}

\item{...}{additional arguments (currently unused)}
}
\value{
A mcvis visualization plot
}
\description{
Multi-collinearity Visualization plots

Multi-collinearity Visualization plots

Multi-collinearity Visualization plots
}
\examples{
set.seed(1)
p = 10
n = 100
X = matrix(rnorm(n*p), ncol = p)
X[,1] = X[,2] + rnorm(n, 0, 0.1)
mcvis_result = mcvis(X)
plot(mcvis_result)
plot(mcvis_result, type = "igraph")
plot(mcvis_result, type = "alt")
}
\author{
Chen Lin, Kevin Wang, Samuel Mueller
}
