% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldecomp.R
\name{ldecomp.getDistances}
\alias{ldecomp.getDistances}
\title{Residuals distances for linear decomposition}
\usage{
ldecomp.getDistances(scores, loadings, residuals, tnorm = NULL,
  cal = FALSE)
}
\arguments{
\item{scores}{matrix with scores (T).}

\item{loadings}{matrix with loadings (P).}

\item{residuals}{matrix with residuals (E).}

\item{tnorm}{vector with singular values for scores normalisation}

\item{cal}{if TRUE method will realize that these distances are calculated for calibration set}
}
\value{
Returns a list with Q, Qvar, T2 and modelling power values for each component.
}
\description{
Computes residual distances (Q and T2) and modelling power for a data decomposition X = TP' + E.
}
\details{
The distances are calculated for every 1:n components, where n goes from 1 to ncomp 
(number of columns in scores and loadings).
}
