% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{plotResiduals.pca}
\alias{plotResiduals.pca}
\title{Residuals plot for PCA}
\usage{
\method{plotResiduals}{pca}(obj, ncomp = NULL, norm = F, main = NULL,
  xlab = NULL, ylab = NULL, show.labels = F, show.legend = T,
  show.limits = T, xlim = NULL, ylim = NULL, lim.col = c("#333333",
  "#333333"), lim.lwd = c(1, 1), lim.lty = c(2, 3), ...)
}
\arguments{
\item{obj}{a PCA model (object of class \code{pca})}

\item{ncomp}{how many components to use (if NULL - user selected optimal value will be used)}

\item{norm}{logical, show normalized Q vs T2 (\code{norm = T}) values or original ones (\code{norm = F})}

\item{main}{main title for the plot}

\item{xlab}{label for x axis}

\item{ylab}{label for y axis}

\item{show.labels}{logical, show or not labels for the plot objects}

\item{show.legend}{logical, show or not a legend on the plot}

\item{show.limits}{logical, show or not lines with statistical limits for the residuals}

\item{xlim}{limits for x-axis}

\item{ylim}{limits for y-axis}

\item{lim.col}{vector with two values - line color for extreme and outlier borders}

\item{lim.lwd}{vector with two values - line width for extreme and outlier borders}

\item{lim.lty}{vector with two values - line type for extreme and outlier borders}

\item{...}{other plot parameters (see \code{mdaplotg} for details)}
}
\description{
Shows a plot with Q residuals vs. Hotelling T2 values for selected number of components.
}
\details{
See examples in help for \code{\link{pca}} function.
}
