/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.core.definitions;

import java.util.LinkedList;

public class Dendrogram {
    private int identifier;
    private String label;
    private double rootBottomHeight = Double.NaN;
    private double rootInternalHeight = Double.NaN;
    private double rootTopHeight = Double.NaN;
    public final boolean isDistanceBased;
    public final int precision;
    private double nodesMinHeight = Double.NaN;
    private double nodesMaxHeight = Double.NaN;
    private double bandsMinHeight = Double.NaN;
    private double bandsMaxHeight = Double.NaN;
    private boolean isSupercluster = true;
    private LinkedList<Dendrogram> subclustersList;
    private LinkedList<Dendrogram> leavesList;

    public Dendrogram(int n, String string, boolean bl, int n2) {
        this.identifier = n;
        this.label = string;
        this.isDistanceBased = bl;
        this.precision = n2;
        this.subclustersList = new LinkedList();
        this.leavesList = new LinkedList();
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public String getLabel() {
        return this.label;
    }

    public void setRootHeights(double d) {
        this.rootBottomHeight = d;
        this.rootInternalHeight = d;
        this.rootTopHeight = d;
    }

    public double getRootBottomHeight() {
        return this.rootBottomHeight;
    }

    public void setRootInternalHeight(double d) {
        this.rootInternalHeight = d;
    }

    public double getRootInternalHeight() {
        return this.rootInternalHeight;
    }

    public void setRootTopHeight(double d) {
        this.rootTopHeight = d;
        this.bandsMinHeight = Math.min(this.bandsMinHeight, d);
        this.bandsMaxHeight = Math.max(this.bandsMaxHeight, d);
    }

    public double getRootTopHeight() {
        return this.rootTopHeight;
    }

    public void setNodesHeights(double d) {
        this.nodesMinHeight = d;
        this.nodesMaxHeight = d;
    }

    public void setBandsHeights(double d) {
        this.bandsMinHeight = d;
        this.bandsMaxHeight = d;
    }

    public double getNodesMinHeight() {
        return this.nodesMinHeight;
    }

    public double getNodesMaxHeight() {
        return this.nodesMaxHeight;
    }

    public double getBandsMinHeight() {
        return this.bandsMinHeight;
    }

    public double getBandsMaxHeight() {
        return this.bandsMaxHeight;
    }

    public void setSupercluster(boolean bl) {
        this.isSupercluster = bl;
    }

    public boolean isSupercluster() {
        return this.isSupercluster;
    }

    public void addSubcluster(Dendrogram dendrogram) {
        this.subclustersList.addLast(dendrogram);
        if (dendrogram.numberOfSubclusters() == 1) {
            this.leavesList.add(dendrogram);
        } else {
            this.leavesList.addAll(dendrogram.leavesList);
        }
        if (Double.isNaN(this.nodesMinHeight)) {
            this.nodesMinHeight = dendrogram.nodesMinHeight;
        } else if (!Double.isNaN(dendrogram.nodesMinHeight)) {
            this.nodesMinHeight = Math.min(this.nodesMinHeight, dendrogram.nodesMinHeight);
        }
        if (Double.isNaN(this.nodesMaxHeight)) {
            this.nodesMaxHeight = dendrogram.nodesMaxHeight;
        } else if (!Double.isNaN(dendrogram.nodesMaxHeight)) {
            this.nodesMaxHeight = Math.max(this.nodesMaxHeight, dendrogram.nodesMaxHeight);
        }
        if (!Double.isNaN(dendrogram.bandsMinHeight)) {
            this.bandsMinHeight = Math.min(this.bandsMinHeight, dendrogram.bandsMinHeight);
        }
        if (!Double.isNaN(dendrogram.bandsMaxHeight)) {
            this.bandsMaxHeight = Math.max(this.bandsMaxHeight, dendrogram.bandsMaxHeight);
        }
    }

    public int numberOfSubclusters() {
        if (this.subclustersList.size() == 0) {
            return 1;
        }
        return this.subclustersList.size();
    }

    public int numberOfSubroots() {
        if (this.isSupercluster) {
            return this.subclustersList.size();
        }
        return 1;
    }

    public Dendrogram getSubcluster(int n) {
        Dendrogram dendrogram = this.subclustersList.isEmpty() && n == 0 ? this : (n < this.subclustersList.size() ? this.subclustersList.get(n) : null);
        return dendrogram;
    }

    public Dendrogram getSubroot(int n) {
        Dendrogram dendrogram = this.isSupercluster ? this.subclustersList.get(n) : (n == 0 ? this : null);
        return dendrogram;
    }

    public int numberOfLeaves() {
        if (this.leavesList.size() == 0) {
            return 1;
        }
        return this.leavesList.size();
    }

    public Dendrogram getLeaf(int n) {
        Dendrogram dendrogram = null;
        if (this.leavesList.isEmpty() && n == 0) {
            dendrogram = this;
        } else if (n < this.leavesList.size()) {
            dendrogram = this.leavesList.get(n);
        }
        return dendrogram;
    }

    public double normalizedTreeBalance() {
        EntropyTuple entropyTuple = this.accumulateEntropy();
        if (entropyTuple.numJunctions == 0) {
            return 0.0;
        }
        double d = entropyTuple.sumEntropy / (double)entropyTuple.numJunctions;
        double d2 = this.minimumTreeBalance();
        return (d - d2) / (1.0 - d2);
    }

    private double minimumTreeBalance() {
        int n = this.numberOfLeaves();
        double d = Math.log(n);
        for (int i = 2; i < n; ++i) {
            d += Math.log(i) / (double)(i + 1);
        }
        return d / ((double)(n - 1) * Math.log(2.0));
    }

    private EntropyTuple accumulateEntropy() {
        EntropyTuple entropyTuple = new EntropyTuple();
        int n = this.numberOfSubclusters();
        if (n > 1) {
            entropyTuple.sumEntropy = this.rootEntropy();
            entropyTuple.numJunctions = 1;
            for (int i = 0; i < n; ++i) {
                Dendrogram dendrogram = this.subclustersList.get(i);
                EntropyTuple entropyTuple2 = dendrogram.accumulateEntropy();
                entropyTuple.sumEntropy += entropyTuple2.sumEntropy;
                entropyTuple.numJunctions += entropyTuple2.numJunctions;
            }
        }
        return entropyTuple;
    }

    private double rootEntropy() {
        double d = 0.0;
        int n = this.numberOfSubclusters();
        if (n > 1) {
            int n2 = this.numberOfLeaves();
            for (int i = 0; i < n; ++i) {
                Dendrogram dendrogram = this.subclustersList.get(i);
                double d2 = (double)dendrogram.numberOfLeaves() / (double)n2;
                d -= d2 * Math.log(d2);
            }
            d /= Math.log(n);
        }
        return d;
    }

    private class EntropyTuple {
        double sumEntropy = 0.0;
        int numJunctions = 0;

        private EntropyTuple() {
        }
    }
}

