/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import multidendrograms.core.definitions.Dendrogram;
import multidendrograms.core.utils.MathUtils;
import multidendrograms.core.utils.SmartAxis;
import multidendrograms.utils.NumberUtils;

public class ToJson {
    private Dendrogram root;
    private boolean isUniformOrigin;
    private double dendroBottomHeight;
    private PrintWriter printWriter;

    public ToJson(Dendrogram dendrogram, boolean bl) {
        this.root = dendrogram;
        this.isUniformOrigin = bl;
        SmartAxis smartAxis = new SmartAxis(dendrogram, bl);
        this.dendroBottomHeight = dendrogram.isDistanceBased ? smartAxis.smartMin() : smartAxis.smartMax();
    }

    public void saveAsJson(String string) throws IOException {
        File file = new File(string);
        FileWriter fileWriter = new FileWriter(file);
        this.printWriter = new PrintWriter(fileWriter);
        this.showCluster(this.root, this.root.getRootBottomHeight(), "");
        this.printWriter.println("");
        this.printWriter.close();
    }

    private void showCluster(Dendrogram dendrogram, double d, String string) {
        int n = dendrogram.numberOfSubclusters();
        double d2 = dendrogram.getRootBottomHeight();
        if (n == 1) {
            double d3 = Double.isNaN(d2) || this.isUniformOrigin ? this.dendroBottomHeight : d2;
            double d4 = d3;
            double d5 = d3;
            String string2 = string + "{\"name\": \"" + dendrogram.getLabel() + "\", ";
            string2 = string2 + this.getClusterHeight(d3) + ", ";
            string2 = string2 + this.getClusterMargin(d4, d5) + ", ";
            string2 = string2 + this.getClusterLength(d, d3) + ", ";
            string2 = string2 + "\"size\": 1}";
            this.printWriter.print(string2);
        } else {
            double d6 = d2;
            double d7 = dendrogram.getRootTopHeight();
            double d8 = dendrogram.getRootBottomHeight();
            this.printWriter.println(string + "{");
            String string3 = string + " \"name\": \"\", ";
            string3 = string3 + this.getClusterHeight(d6) + ", ";
            string3 = string3 + this.getClusterMargin(d7, d8) + ", ";
            string3 = string3 + this.getClusterLength(d, d6) + ",";
            this.printWriter.println(string3);
            string3 = string + " \"children\": [";
            this.printWriter.println(string3);
            for (int i = 0; i < n; ++i) {
                this.showCluster(dendrogram.getSubcluster(i), d6, string + "  ");
                if (i < n - 1) {
                    this.printWriter.print(",");
                }
                this.printWriter.println("");
            }
            this.printWriter.println(string + " ]");
            this.printWriter.print(string + "}");
        }
    }

    private String getClusterHeight(double d) {
        int n = this.root.precision;
        String string = NumberUtils.format(d, n);
        return "\"height\": " + string;
    }

    private String getClusterMargin(double d, double d2) {
        int n = this.root.precision;
        double d3 = Math.abs(d - d2);
        String string = NumberUtils.format(d3, n);
        return "\"margin\": " + string;
    }

    private String getClusterLength(double d, double d2) {
        int n = this.root.precision;
        double d3 = this.root.isDistanceBased ? MathUtils.round(d, n) - MathUtils.round(d2, n) : MathUtils.round(d2, n) - MathUtils.round(d, n);
        d3 = MathUtils.round(d3, n);
        String string = NumberUtils.format(d3, n);
        return "\"length\": " + string;
    }
}

