/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram.figures;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import multidendrograms.dendrogram.Scaling;
import multidendrograms.dendrogram.eps.EpsUtils;
import multidendrograms.dendrogram.figures.Figure;
import multidendrograms.initial.LogManager;
import multidendrograms.types.DendrogramOrientation;
import multidendrograms.types.PlotType;

public class Band
extends Figure {
    private double height;
    private double width;
    private boolean filled;

    public Band(double d, double d2, double d3, double d4) {
        super(d, d2, Color.GRAY);
        this.height = d3;
        this.width = d4;
        this.filled = true;
    }

    public Band(double d, double d2, double d3, double d4, Color color) {
        super(d, d2, color);
        this.height = d3;
        this.width = d4;
        this.filled = true;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public boolean getFilled() {
        return this.filled;
    }

    public void setFilled(boolean bl) {
        this.filled = bl;
    }

    @Override
    public void draw(PlotType plotType, Graphics2D graphics2D) {
        double d;
        double d2 = this.getPosReal().getX();
        double d3 = this.getPosReal().getY();
        double d4 = d2 + this.width;
        double d5 = d3 + this.height;
        LogManager.LOG.finest("Real coord.: x1 = " + d2 + "    y1 = " + d3 + "    x2 = " + d4 + "    y2 = " + d5);
        Scaling scaling = this.getScaling();
        double d6 = scaling.getMinX();
        double d7 = scaling.getMaxX();
        double d8 = scaling.getMinY();
        double d9 = scaling.getMaxY();
        DendrogramOrientation dendrogramOrientation = this.getDendrogramOrientation();
        if (dendrogramOrientation == DendrogramOrientation.EAST) {
            d = d3;
            d3 = d8 + (d9 - d2);
            d2 = d;
            double d10 = d5;
            d5 = d8 + (d9 - d4);
            d4 = d10;
            d = d3;
            d3 = d5;
            d5 = d;
        } else if (dendrogramOrientation == DendrogramOrientation.WEST) {
            d = d2;
            d2 = d6 + (d7 - d3);
            d3 = d8 + (d9 - d);
            double d11 = d4;
            d4 = d6 + (d7 - d5);
            d5 = d8 + (d9 - d11);
            d = d2;
            d2 = d4;
            d4 = d;
            double d12 = d3;
            d3 = d5;
            d5 = d12;
        } else if (dendrogramOrientation == DendrogramOrientation.SOUTH) {
            d3 = d8 + (d9 - d3);
            d5 = d8 + (d9 - d5);
            d = d3;
            d3 = d5;
            d5 = d;
        }
        d2 = scaling.transformX(d2);
        d3 = scaling.transformY(d3);
        d4 = scaling.transformX(d4);
        d5 = scaling.transformY(d5);
        if (plotType.equals((Object)PlotType.PANEL)) {
            Color color = graphics2D.getColor();
            if (this.filled) {
                graphics2D.setPaint(this.getColor());
                graphics2D.setColor(this.getColor());
                graphics2D.fill(new Rectangle2D.Double(d2, d3, d4 - d2, d5 - d3));
            } else {
                graphics2D.setColor(Color.BLACK);
                graphics2D.draw(new Rectangle2D.Double(d2, d3, d4 - d2, d5 - d3));
            }
            graphics2D.setColor(color);
        } else {
            EpsUtils.writeLine("gsave");
            Color color = this.filled ? this.getColor() : Color.BLACK;
            EpsUtils.writeLine(EpsUtils.setRGBColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f));
            if (this.filled) {
                EpsUtils.writeLine(EpsUtils.fRectangle((float)((double)EpsUtils.xmin + d2), (float)((double)EpsUtils.ymax + d3), (float)((double)EpsUtils.xmin + d4), (float)((double)EpsUtils.ymax + d5)));
            } else {
                EpsUtils.writeLine(EpsUtils.dRectangle((float)((double)EpsUtils.xmin + d2), (float)((double)EpsUtils.ymax + d3), (float)((double)EpsUtils.xmin + d4), (float)((double)EpsUtils.ymax + d5)));
            }
            EpsUtils.writeLine("grestore");
        }
        LogManager.LOG.finest("draw Rectangle2D(" + d2 + ", " + d3 + ", " + (d4 - d2) + ", " + (d5 - d3) + ")");
    }
}

