/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.initial;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import javax.swing.JOptionPane;
import multidendrograms.errors.Warning;
import multidendrograms.initial.LogManager;

public class Language {
    private int index = 0;
    private static Vector<String> labels = null;

    public Language(String string) throws Exception {
        try {
            this.loadLabels(string);
        }
        catch (Warning warning) {
            JOptionPane.showMessageDialog(null, warning.getMessage(), "Dendrogram", 0);
            LogManager.LOG.warning(warning.getMessage());
        }
        catch (Exception exception) {
            String string2 = Language.getLabel(68);
            LogManager.LOG.throwing("Language", "Language(String path)", exception);
            throw new Exception(string2);
        }
    }

    public static String getLabel(int n) {
        return labels.get(n);
    }

    private void loadLabels(String string) throws Exception {
        labels = new Vector();
        try {
            String string2;
            File file = new File(string);
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                labels.add(this.index++, string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            String string3 = exception.toString();
            string3 = "WARNING: cannot load language file (" + string + "). Loading default language\n" + string3;
            this.getDefaultLangLabels();
            throw new Warning(string3);
        }
    }

    private void getDefaultLangLabels() {
        String[] stringArray = new String[]{"Are you sure you want to exit?", "Color selection", "Invalid value in 'Precision' field", "Invalid value in 'Minimum value' field", "Invalid value in 'Maximum value' field", "Invalid value in 'Ticks separation' field", "Invalid value in 'Labels every' field", "Error", "The file was not loaded", "Working data", "Ambiguous file. It will be taken as a list-like file", "The loaded file is not compatible with this application", "Asymmetric data: two different values for the same data pair", "Error at line", "The third column must contain a numeric value", "Missing data values, filling them with the default value in 'md.ini' file", "Incompatible file", "The cluster is not in the group", "Unable to recover the cluster", "Incompatible min. and max. values", "File", "Load", "View", "Settings", "Clustering algorithm", "Dendrogram", "Tree orientation", "Distance", "Similarity", "Tree", "Nodes", "Show labels", "Nodes", "Labels orientation", "Font", "Color", "Axis", "Show axis", "Color", "Show labels", "Color", "Minimum value", "Maximum value", "Ticks separation", "Labels every", "Font", "Exit", "An unknown event was received", "Show bands", "Labels decimals", "Invalid value in 'Labels decimals' field", "Precision", "Info", "Algorithm parameter", "Bold", "Italic", "Plain", "Selected font", "Font selection", "Font", "OK", "Cancel", "Root", "Weighted", "Unable to process the dendrogram figure", "File header not found, default values will be loaded", "Property not found", "Unable to create the properties file", "'Algorithm parameter' must lie between -1 and +1", "Unknown error", "Unable to recover the cluster", "Unable to save the distance", "Unable to recover the matrix", "Unable to initialize the matrix", "Unable to load the dendrogram properties", "Save as", "Unable to save the image", "Null image", "Unable to build the hierarchy tree", "Save dendrogram as JSON tree", "Clustering algorithm incompatible with negative data", "Unable to create the file", "Existing file. Do you want to overwrite it?", "Cannot write", "Cannot load", "Icon not found", "Unable to recover the precision value", "Save dendrogram as Newick tree", "North", "South", "East", "West", "Horizontal", "Oblique", "Vertical", "Show dendrogram tree structure", "Save dendrogram as JPG", "Save dendrogram as PNG", "Save dendrogram as TXT", "Save dendrogram as EPS", "The number of rows is larger than the number of columns", "A number not equal to 0 has been found in the diagonal", "value discarded in line", "There is no data in the file", "The columns count is wrong at line", "of the file", "File not found", "Cannot read/write to file", "Cannot write to file", "Cannot read from file", "Update", "Save dendrogram measures", "No file loaded", "Nodes size", "Type of measure", "ticks", "Save ultrametric matrix", "Show dendrogram measures", "Version", "Developers", "Advisors", "GNU Lesser Public License", "Project website", "Dendrogram measures", "Manual online", "A non-numeric character has been found in a row or column larger than 1", "Additional warning messages skipped", "Error reading file", "at line", "New", "available at", "Current version is", "Uniform origin", "Equivalences between clustering algorithms"};
        labels = new Vector();
        this.index = 0;
        for (String string : stringArray) {
            labels.add(this.index++, string);
        }
    }
}

