/*
 * Copyright (C) Justo Montiel, David Torres, Sergio Gomez, Alberto Fernandez
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see
 * <http://www.gnu.org/licenses/>
 */

package multidendrograms.core.clusterings;

import multidendrograms.core.definitions.Dendrogram;
import multidendrograms.core.definitions.SymmetricMatrix;

/******************************************************************************
 * <p>
 * <b>MultiDendrograms</b>
 * </p>
 *
 * Complete-Linkage agglomerative hierarchical clustering
 *
 * @author Sergio Gomez, Alberto Fernandez, Justo Montiel, David Torres
 *
 * @since JDK 6.0
 ******************************************************************************/
public class CompleteLinkage extends HierarchicalClustering {

	public CompleteLinkage(SymmetricMatrix proximityMatrix, String[] labels, 
			boolean isDistanceBased, int precision) {
		super(proximityMatrix, labels, isDistanceBased, precision);
	}

	@Override
	protected double calculateProximity(Dendrogram cI, Dendrogram cJ) {
		if (this.isDistanceBased) {
			return maximumProximity(cI, cJ);
		} else {
			return minimumProximity(cI, cJ);
		}
	}

	protected double calculateInternalProximity(Dendrogram c) {
		if (this.isDistanceBased) {
			return maximumInternalProximity(c);
		} else {
			return minimumInternalProximity(c);
		}
	}

}
