% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Minneapolis2013}
\alias{Minneapolis2013}
\title{Ballots in the 2013 Mayoral election in Minneapolis}
\format{
A data frame with 80,101 observations on the following 5 variables.
All are stored as character strings.  
\describe{
 \item{Precinct}{Precincts are sub-divisions within Wards}
 \item{First}{The voter's first choice} 
 \item{Second}{The voter's second choice}
 \item{Third}{The voter's third choice}
 \item{Ward}{The city is divided spatially into districts or 'wards'.
These are further subdivided into precincts. } 
}
}
\source{
Ballot data from the Minneapolis city government:
\url{https://vote.minneapolismn.gov/results-data/election-results/2013/mayor/}
}
\usage{
Minneapolis2013
}
\description{
The choices marked on each (valid) ballot for the election, which was run
using a rank-choice, instant runoff system.
}
\details{
Ballot information for the 2013 Minneapolis Mayoral election, which was run
as a rank-choice election.  In rank-choice, a voter can indicate first,
second, and third choices.  If a voter's first choice is eliminated (by
being last in the count across voters), the second choice is promoted to
that voter's first choice, and similarly third -> second.  Eliminations are
done successively until one candidate has a majority of the first-choice
votes.
}
\examples{

data(Minneapolis2013)
}
\references{
Description of ranked-choice voting:
\url{https://vote.minneapolismn.gov/ranked-choice-voting/}

A Minnesota Public Radio story about the election ballot tallying process:
\url{https://www.mprnews.org/2013/11/22/politics/ranked-choice-vote-count-programmers/}

The Wikipedia article about the election:
\url{https://en.wikipedia.org/wiki/2013_Minneapolis_mayoral_election}
}
\keyword{datasets}
